/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.we;

import in.clouthink.daas.we.ErrorCodeProvider;
import in.clouthink.daas.we.ErrorDataProvider;
import in.clouthink.daas.we.ErrorDataResponse;
import in.clouthink.daas.we.ErrorResponse;
import in.clouthink.daas.we.FormError;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class ResponseEntityBuilder {
    private static ResponseEntityBuilder developerBuilder = new ResponseEntityBuilder(true);
    private static ResponseEntityBuilder productionBuilder = new ResponseEntityBuilder(false);
    private boolean developerMode;

    public static ResponseEntityBuilder getBuilder(boolean developerMode) {
        return developerMode ? developerBuilder : productionBuilder;
    }

    public static ResponseEntityBuilder getDeveloperBuilder() {
        return developerBuilder;
    }

    public static ResponseEntityBuilder getProductionBuilder() {
        return productionBuilder;
    }

    public ResponseEntityBuilder(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, HttpStatus status) {
        return this.buildResponseEntity(ex, null, new HttpHeaders(), status, null);
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, String message, HttpStatus status) {
        return this.buildResponseEntity(ex, message, new HttpHeaders(), status, null);
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, HttpStatus status, List<FormError> formErrors) {
        return this.buildResponseEntity(ex, null, new HttpHeaders(), status, formErrors);
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, String message, HttpStatus status, List<FormError> formErrors) {
        return this.buildResponseEntity(ex, message, new HttpHeaders(), status, formErrors);
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, HttpHeaders headers, HttpStatus status) {
        return this.buildResponseEntity(ex, null, headers, status, null);
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, String message, HttpHeaders headers, HttpStatus status) {
        return this.buildResponseEntity(ex, message, headers, status, null);
    }

    public ResponseEntity<ErrorResponse> buildResponseEntity(Exception ex, String message, HttpHeaders headers, HttpStatus status, Object errorData) {
        ErrorDataResponse<Object> errorResponse = new ErrorDataResponse<Object>();
        if (errorData != null || ex instanceof ErrorDataProvider) {
            errorResponse = new ErrorDataResponse<Object>();
        }
        if (ex instanceof ErrorCodeProvider) {
            String errorCode = ((ErrorCodeProvider)((Object)ex)).getErrorCode();
            errorResponse.setErrorCode(errorCode);
        } else {
            errorResponse.setErrorCode(Integer.toString(status.value()));
        }
        if (!StringUtils.isEmpty((Object)message)) {
            errorResponse.setErrorMessage(message);
        } else {
            errorResponse.setErrorMessage(ex.getMessage());
        }
        if (this.developerMode) {
            errorResponse.setDeveloperMessage(this.getStackTrace(ex));
        }
        if (errorData != null) {
            errorResponse.setErrorData(errorData);
        } else if (ex instanceof ErrorDataProvider) {
            errorResponse.setErrorData(((ErrorDataProvider)((Object)ex)).getErrorData());
        }
        headers.set("Content-Type", "application/json");
        return new ResponseEntity(errorResponse, (MultiValueMap)headers, status);
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

