/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import org.csource.common.FastdfsException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.DownloadCallback;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdfs.UploadCallback;

public class StorageClient1
extends StorageClient {
    public static final String SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR = "/";

    public StorageClient1() {
    }

    public StorageClient1(TrackerServer trackerServer, StorageServer storageServer) {
        super(trackerServer, storageServer);
    }

    public static byte splitFileId(String file_id, String[] results) {
        int pos = file_id.indexOf(SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR);
        if (pos <= 0 || pos == file_id.length() - 1) {
            return 22;
        }
        results[0] = file_id.substring(0, pos);
        results[1] = file_id.substring(pos + 1);
        return 0;
    }

    public String uploadFile1(String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadFile(local_filename, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadFile(group_name, local_filename, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadFile(file_buff, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String group_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadFile(group_name, file_buff, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String group_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadFile(group_name, file_size, callback, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadAppenderFile1(String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadAppenderFile(local_filename, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadAppenderFile1(String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadAppenderFile(group_name, local_filename, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadAppenderFile1(byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadAppenderFile(file_buff, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadAppenderFile1(String group_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadAppenderFile(group_name, file_buff, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadAppenderFile1(String group_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = this.uploadAppenderFile(group_name, file_size, callback, file_ext_name, meta_list);
        if (parts != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String master_file_id, String prefix_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(master_file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        if ((parts = this.uploadFile(parts[0], parts[1], prefix_name, local_filename, file_ext_name, meta_list)) != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String master_file_id, String prefix_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(master_file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        if ((parts = this.uploadFile(parts[0], parts[1], prefix_name, file_buff, file_ext_name, meta_list)) != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String master_file_id, String prefix_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(master_file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        if ((parts = this.uploadFile(parts[0], parts[1], prefix_name, file_buff, offset, length, file_ext_name, meta_list)) != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public String uploadFile1(String master_file_id, String prefix_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(master_file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        if ((parts = this.uploadFile(parts[0], parts[1], prefix_name, file_size, callback, file_ext_name, meta_list)) != null) {
            return parts[0] + SPLIT_GROUP_NAME_AND_FILENAME_SEPERATOR + parts[1];
        }
        return null;
    }

    public int appendFile1(String appender_file_id, String local_filename) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.appendFile(parts[0], parts[1], local_filename);
    }

    public int appendFile1(String appender_file_id, byte[] file_buff) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.appendFile(parts[0], parts[1], file_buff);
    }

    public int appendFile1(String appender_file_id, byte[] file_buff, int offset, int length) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.appendFile(parts[0], parts[1], file_buff, offset, length);
    }

    public int appendFile1(String appender_file_id, long file_size, UploadCallback callback) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.appendFile(parts[0], parts[1], file_size, callback);
    }

    public int modifyFile1(String appender_file_id, long file_offset, String local_filename) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.modifyFile(parts[0], parts[1], file_offset, local_filename);
    }

    public int modifyFile1(String appender_file_id, long file_offset, byte[] file_buff) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.modifyFile(parts[0], parts[1], file_offset, file_buff);
    }

    public int modifyFile1(String appender_file_id, long file_offset, byte[] file_buff, int buffer_offset, int buffer_length) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.modifyFile(parts[0], parts[1], file_offset, file_buff, buffer_offset, buffer_length);
    }

    public int modifyFile1(String appender_file_id, long file_offset, long modify_size, UploadCallback callback) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.modifyFile(parts[0], parts[1], file_offset, modify_size, callback);
    }

    public int deleteFile1(String file_id) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.deleteFile(parts[0], parts[1]);
    }

    public int truncateFile1(String appender_file_id) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.truncateFile(parts[0], parts[1]);
    }

    public int truncateFile1(String appender_file_id, long truncated_file_size) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(appender_file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.truncateFile(parts[0], parts[1], truncated_file_size);
    }

    public byte[] downloadFile1(String file_id) throws IOException, FastdfsException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.downloadFile1(file_id, 0L, 0L);
    }

    public byte[] downloadFile1(String file_id, long file_offset, long download_bytes) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        return this.downloadFile(parts[0], parts[1], file_offset, download_bytes);
    }

    public int downloadFile1(String file_id, String local_filename) throws IOException, FastdfsException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.downloadFile1(file_id, 0L, 0L, local_filename);
    }

    public int downloadFile1(String file_id, long file_offset, long download_bytes, String local_filename) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.downloadFile(parts[0], parts[1], file_offset, download_bytes, local_filename);
    }

    public int downloadFile1(String file_id, DownloadCallback callback) throws IOException, FastdfsException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.downloadFile1(file_id, 0L, 0L, callback);
    }

    public int downloadFile1(String file_id, long file_offset, long download_bytes, DownloadCallback callback) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.downloadFile(parts[0], parts[1], file_offset, download_bytes, callback);
    }

    public NameValuePair[] getMetadata1(String file_id) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        return this.getMetadata(parts[0], parts[1]);
    }

    public int setMetadata1(String file_id, NameValuePair[] meta_list, byte op_flag) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return this.errno;
        }
        return this.setMetadata(parts[0], parts[1], meta_list, op_flag);
    }

    public FileInfo queryFileInfo1(String file_id) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        return this.queryFileInfo(parts[0], parts[1]);
    }

    public FileInfo getFileInfo1(String file_id) throws IOException, FastdfsException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        return this.getFileInfo(parts[0], parts[1]);
    }
}

