/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.ProtoStructDecoder;
import org.csource.fastdfs.ServerInfo;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.StructGroupStat;
import org.csource.fastdfs.StructStorageStat;
import org.csource.fastdfs.TrackerGroup;
import org.csource.fastdfs.TrackerServer;

public class TrackerClient {
    protected TrackerGroup tracker_group;
    protected byte errno;

    public TrackerClient() {
        this.tracker_group = ClientGlobal.trackerGroup;
    }

    public TrackerClient(TrackerGroup tracker_group) {
        this.tracker_group = tracker_group;
    }

    public byte getErrorCode() {
        return this.errno;
    }

    public TrackerServer getConnection() {
        return this.tracker_group.getConnection();
    }

    public StorageServer getStoreStorage(TrackerServer trackerServer) throws IOException {
        String groupName = null;
        return this.getStoreStorage(trackerServer, groupName);
    }

    public StorageServer getStoreStorage(TrackerServer trackerServer, String groupName) throws IOException {
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            Object bs;
            int out_len;
            byte cmd;
            if (groupName == null || groupName.length() == 0) {
                cmd = 101;
                out_len = 0;
            } else {
                cmd = 104;
                out_len = 16;
            }
            byte[] header = ProtoCommon.packHeader(cmd, out_len, (byte)0);
            out.write(header);
            if (groupName != null && groupName.length() > 0) {
                bs = groupName.getBytes(ClientGlobal.charset);
                byte[] bGroupName = new byte[16];
                int group_len = ((byte[])bs).length <= 16 ? ((byte[])bs).length : 16;
                Arrays.fill(bGroupName, (byte)0);
                System.arraycopy(bs, 0, bGroupName, 0, group_len);
                out.write(bGroupName);
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, 40L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                bs = null;
                return bs;
            }
            String ip_addr = new String(pkgInfo.body, 16, 15).trim();
            int port = (int)ProtoCommon.buff2long(pkgInfo.body, 31);
            byte store_path = pkgInfo.body[39];
            bs = new StorageServer(ip_addr, port, store_path);
            return bs;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    public StorageServer[] getStoreStorages(TrackerServer trackerServer, String groupName) throws IOException {
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            byte[] bs;
            int out_len;
            byte cmd;
            if (groupName == null || groupName.length() == 0) {
                cmd = 106;
                out_len = 0;
            } else {
                cmd = 107;
                out_len = 16;
            }
            byte[] header = ProtoCommon.packHeader(cmd, out_len, (byte)0);
            out.write(header);
            if (groupName != null && groupName.length() > 0) {
                bs = groupName.getBytes(ClientGlobal.charset);
                byte[] bGroupName = new byte[16];
                int group_len = bs.length <= 16 ? bs.length : 16;
                Arrays.fill(bGroupName, (byte)0);
                System.arraycopy(bs, 0, bGroupName, 0, group_len);
                out.write(bGroupName);
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                bs = null;
                return bs;
            }
            if (pkgInfo.body.length < 40) {
                this.errno = (byte)22;
                bs = null;
                return bs;
            }
            int ipPortLen = pkgInfo.body.length - 17;
            int recordLength = 23;
            if (ipPortLen % 23 != 0) {
                this.errno = (byte)22;
                StorageServer[] storageServerArray = null;
                return storageServerArray;
            }
            int serverCount = ipPortLen / 23;
            if (serverCount > 16) {
                this.errno = (byte)28;
                StorageServer[] ex1 = null;
                return ex1;
            }
            StorageServer[] results = new StorageServer[serverCount];
            byte store_path = pkgInfo.body[pkgInfo.body.length - 1];
            int offset = 16;
            for (int i = 0; i < serverCount; ++i) {
                String ip_addr = new String(pkgInfo.body, offset, 15).trim();
                int port = (int)ProtoCommon.buff2long(pkgInfo.body, offset += 15);
                offset += 8;
                results[i] = new StorageServer(ip_addr, port, store_path);
            }
            StorageServer[] storageServerArray = results;
            return storageServerArray;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    public StorageServer getFetchStorage(TrackerServer trackerServer, String groupName, String filename) throws IOException {
        ServerInfo[] servers = this.getStorages(trackerServer, (byte)102, groupName, filename);
        if (servers == null) {
            return null;
        }
        return new StorageServer(servers[0].getIpAddr(), servers[0].getPort(), 0);
    }

    public StorageServer getUpdateStorage(TrackerServer trackerServer, String groupName, String filename) throws IOException {
        ServerInfo[] servers = this.getStorages(trackerServer, (byte)103, groupName, filename);
        if (servers == null) {
            return null;
        }
        return new StorageServer(servers[0].getIpAddr(), servers[0].getPort(), 0);
    }

    public ServerInfo[] getFetchStorages(TrackerServer trackerServer, String groupName, String filename) throws IOException {
        return this.getStorages(trackerServer, (byte)105, groupName, filename);
    }

    protected ServerInfo[] getStorages(TrackerServer trackerServer, byte cmd, String groupName, String filename) throws IOException {
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            byte[] bs = groupName.getBytes(ClientGlobal.charset);
            byte[] bGroupName = new byte[16];
            byte[] bFileName = filename.getBytes(ClientGlobal.charset);
            int len = bs.length <= 16 ? bs.length : 16;
            Arrays.fill(bGroupName, (byte)0);
            System.arraycopy(bs, 0, bGroupName, 0, len);
            byte[] header = ProtoCommon.packHeader(cmd, 16 + bFileName.length, (byte)0);
            byte[] wholePkg = new byte[header.length + bGroupName.length + bFileName.length];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(bGroupName, 0, wholePkg, header.length, bGroupName.length);
            System.arraycopy(bFileName, 0, wholePkg, header.length + bGroupName.length, bFileName.length);
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                ServerInfo[] serverInfoArray = null;
                return serverInfoArray;
            }
            if (pkgInfo.body.length < 39) {
                throw new IOException("Invalid body length: " + pkgInfo.body.length);
            }
            if ((pkgInfo.body.length - 39) % 15 != 0) {
                throw new IOException("Invalid body length: " + pkgInfo.body.length);
            }
            int server_count = 1 + (pkgInfo.body.length - 39) / 15;
            String ip_addr = new String(pkgInfo.body, 16, 15).trim();
            int offset = 31;
            int port = (int)ProtoCommon.buff2long(pkgInfo.body, offset);
            offset += 8;
            ServerInfo[] servers = new ServerInfo[server_count];
            servers[0] = new ServerInfo(ip_addr, port);
            for (int i = 1; i < server_count; ++i) {
                servers[i] = new ServerInfo(new String(pkgInfo.body, offset, 15).trim(), port);
                offset += 15;
            }
            ServerInfo[] serverInfoArray = servers;
            return serverInfoArray;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    public StorageServer getFetchStorage1(TrackerServer trackerServer, String file_id) throws IOException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        return this.getFetchStorage(trackerServer, parts[0], parts[1]);
    }

    public ServerInfo[] getFetchStorages1(TrackerServer trackerServer, String file_id) throws IOException {
        String[] parts = new String[2];
        this.errno = StorageClient1.splitFileId(file_id, parts);
        if (this.errno != 0) {
            return null;
        }
        return this.getFetchStorages(trackerServer, parts[0], parts[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructGroupStat[] listGroups(TrackerServer trackerServer) throws IOException {
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            byte[] header = ProtoCommon.packHeader((byte)91, 0L, (byte)0);
            out.write(header);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                StructGroupStat[] structGroupStatArray = null;
                return structGroupStatArray;
            }
            ProtoStructDecoder decoder = new ProtoStructDecoder();
            StructGroupStat[] ex1 = (StructGroupStat[])decoder.decode(pkgInfo.body, StructGroupStat.class, StructGroupStat.getFieldsTotalSize());
            return ex1;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errno = (byte)22;
            StructGroupStat[] structGroupStatArray = null;
            return structGroupStatArray;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    public StructStorageStat[] listStorages(TrackerServer trackerServer, String groupName) throws IOException {
        String storageIpAddr = null;
        return this.listStorages(trackerServer, groupName, storageIpAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructStorageStat[] listStorages(TrackerServer trackerServer, String groupName, String storageIpAddr) throws IOException {
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            int ipAddrLen;
            byte[] bIpAddr;
            byte[] bs = groupName.getBytes(ClientGlobal.charset);
            byte[] bGroupName = new byte[16];
            int len = bs.length <= 16 ? bs.length : 16;
            Arrays.fill(bGroupName, (byte)0);
            System.arraycopy(bs, 0, bGroupName, 0, len);
            if (storageIpAddr != null && storageIpAddr.length() > 0) {
                bIpAddr = storageIpAddr.getBytes(ClientGlobal.charset);
                ipAddrLen = bIpAddr.length < 16 ? bIpAddr.length : 15;
            } else {
                bIpAddr = null;
                ipAddrLen = 0;
            }
            byte[] header = ProtoCommon.packHeader((byte)92, 16 + ipAddrLen, (byte)0);
            byte[] wholePkg = new byte[header.length + bGroupName.length + ipAddrLen];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(bGroupName, 0, wholePkg, header.length, bGroupName.length);
            if (ipAddrLen > 0) {
                System.arraycopy(bIpAddr, 0, wholePkg, header.length + bGroupName.length, ipAddrLen);
            }
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                StructStorageStat[] structStorageStatArray = null;
                return structStorageStatArray;
            }
            ProtoStructDecoder decoder = new ProtoStructDecoder();
            StructStorageStat[] structStorageStatArray = (StructStorageStat[])decoder.decode(pkgInfo.body, StructStorageStat.class, StructStorageStat.getFieldsTotalSize());
            return structStorageStatArray;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errno = (byte)22;
            StructStorageStat[] structStorageStatArray = null;
            return structStorageStatArray;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    private boolean deleteStorage(TrackerServer trackerServer, String groupName, String storageIpAddr) throws IOException {
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        byte[] bs = groupName.getBytes(ClientGlobal.charset);
        byte[] bGroupName = new byte[16];
        int len = bs.length <= 16 ? bs.length : 16;
        Arrays.fill(bGroupName, (byte)0);
        System.arraycopy(bs, 0, bGroupName, 0, len);
        byte[] bIpAddr = storageIpAddr.getBytes(ClientGlobal.charset);
        int ipAddrLen = bIpAddr.length < 16 ? bIpAddr.length : 15;
        byte[] header = ProtoCommon.packHeader((byte)93, 16 + ipAddrLen, (byte)0);
        byte[] wholePkg = new byte[header.length + bGroupName.length + ipAddrLen];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(bGroupName, 0, wholePkg, header.length, bGroupName.length);
        System.arraycopy(bIpAddr, 0, wholePkg, header.length + bGroupName.length, ipAddrLen);
        out.write(wholePkg);
        ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, 0L);
        this.errno = pkgInfo.errno;
        return pkgInfo.errno == 0;
    }

    public boolean deleteStorage(String groupName, String storageIpAddr) throws IOException {
        return this.deleteStorage(ClientGlobal.trackerGroup, groupName, storageIpAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStorage(TrackerGroup trackerGroup, String groupName, String storageIpAddr) throws IOException {
        TrackerServer trackerServer;
        int serverIndex;
        int notFoundCount = 0;
        for (serverIndex = 0; serverIndex < trackerGroup.tracker_servers.length; ++serverIndex) {
            try {
                trackerServer = trackerGroup.getConnection(serverIndex);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                this.errno = (byte)61;
                return false;
            }
            try {
                StructStorageStat[] storageStats = this.listStorages(trackerServer, groupName, storageIpAddr);
                if (storageStats == null) {
                    if (this.errno == 2) {
                        ++notFoundCount;
                        continue;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (storageStats.length == 0) {
                    ++notFoundCount;
                    continue;
                }
                if (storageStats[0].getStatus() != 6 && storageStats[0].getStatus() != 7) continue;
                this.errno = (byte)16;
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        if (notFoundCount == trackerGroup.tracker_servers.length) {
            this.errno = (byte)2;
            return false;
        }
        notFoundCount = 0;
        for (serverIndex = 0; serverIndex < trackerGroup.tracker_servers.length; ++serverIndex) {
            try {
                trackerServer = trackerGroup.getConnection(serverIndex);
            }
            catch (IOException ex) {
                System.err.println("connect to server " + trackerGroup.tracker_servers[serverIndex].getAddress().getHostAddress() + ":" + trackerGroup.tracker_servers[serverIndex].getPort() + " fail");
                ex.printStackTrace(System.err);
                this.errno = (byte)61;
                return false;
            }
            try {
                if (this.deleteStorage(trackerServer, groupName, storageIpAddr) || this.errno == 0) continue;
                if (this.errno == 2) {
                    ++notFoundCount;
                    continue;
                }
                if (this.errno == 114) continue;
                boolean ex = false;
                return ex;
            }
            finally {
                try {
                    trackerServer.close();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        if (notFoundCount == trackerGroup.tracker_servers.length) {
            this.errno = (byte)2;
            return false;
        }
        if (this.errno == 2) {
            this.errno = 0;
        }
        return this.errno == 0;
    }
}

