package com.dilwar.normalAdapters

import androidx.recyclerview.widget.RecyclerView

interface ListData<M> : BaseFilterable<M> {
    val adapter: RecyclerView.Adapter<*>
    val filterList: MutableList<M>

    fun getAllItems(): List<M> {
        return primaryDataList
    }

    fun getFilteredList(): List<M> {
        return filterList
    }

    fun addItem(item: M) {
        addItem(item, filterList.size)
    }

    fun addItem(item: M, position: Int) {
        primaryDataList.add(position, item)
        filterList.add(position, item)
        adapter.notifyItemInserted(position)
    }

    fun removeItemAt(position: Int) {
        val data = filterList[position]
        removeItem(data)
    }

    fun removeItem(data: M) {
        primaryDataList.remove(data)
        filterList.remove(data)
        adapter.notifyDataSetChanged()
    }


}