/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessageV3;
import in.dragonbra.javasteam.base.GCMsgBase;
import in.dragonbra.javasteam.base.IPacketGCMsg;
import in.dragonbra.javasteam.generated.MsgGCHdrProtoBuf;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientGCMsgProtobuf<BodyType extends GeneratedMessageV3.Builder<BodyType>>
extends GCMsgBase<MsgGCHdrProtoBuf> {
    private static final Logger logger = LogManager.getLogger(ClientGCMsgProtobuf.class);
    private BodyType body;
    private Class<? extends AbstractMessage> clazz;

    public ClientGCMsgProtobuf(Class<? extends AbstractMessage> clazz, IPacketGCMsg msg) {
        this((Class<AbstractMessage>)clazz, msg.getMsgType());
        if (!msg.isProto()) {
            logger.debug("ClientMsgProtobuf<" + clazz.getSimpleName() + "> used for non-proto message!");
        }
        this.deserialize(msg.getData());
    }

    public ClientGCMsgProtobuf(Class<? extends AbstractMessage> clazz, int eMsg) {
        this(clazz, eMsg, 64);
    }

    public ClientGCMsgProtobuf(Class<? extends AbstractMessage> clazz, int eMsg, int payloadReserve) {
        super(MsgGCHdrProtoBuf.class, payloadReserve);
        this.clazz = clazz;
        try {
            Method m = clazz.getMethod("newBuilder", new Class[0]);
            this.body = (GeneratedMessageV3.Builder)m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug(e);
        }
        ((MsgGCHdrProtoBuf)this.getHeader()).setEMsg(eMsg);
    }

    public ClientGCMsgProtobuf(Class<? extends AbstractMessage> clazz, int eMsg, GCMsgBase<MsgGCHdrProtoBuf> msg) {
        this(clazz, eMsg, msg, 64);
    }

    public ClientGCMsgProtobuf(Class<? extends AbstractMessage> clazz, int eMsg, GCMsgBase<MsgGCHdrProtoBuf> msg, int payloadReserve) {
        this(clazz, eMsg, payloadReserve);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        ((MsgGCHdrProtoBuf)this.getHeader()).getProto().setJobidTarget(msg.getHeader().getProto().getJobidSource());
    }

    @Override
    public boolean isProto() {
        return true;
    }

    @Override
    public int getMsgType() {
        return ((MsgGCHdrProtoBuf)this.getHeader()).getMsg();
    }

    @Override
    public JobID getTargetJobID() {
        return new JobID(this.getProtoHeader().getJobidTarget());
    }

    @Override
    public void setTargetJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        this.getProtoHeader().setJobidTarget(jobID.getValue());
    }

    @Override
    public JobID getSourceJobID() {
        return new JobID(this.getProtoHeader().getJobidSource());
    }

    @Override
    public void setSourceJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        this.getProtoHeader().setJobidSource(jobID.getValue());
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ((MsgGCHdrProtoBuf)this.getHeader()).serialize(baos);
            this.body.build().writeTo((OutputStream)baos);
            baos.write(this.payload.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    @Override
    public void deserialize(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        BinaryReader ms = new BinaryReader(new ByteArrayInputStream(data));
        try {
            ((MsgGCHdrProtoBuf)this.getHeader()).deserialize(ms);
            Method m = this.clazz.getMethod("newBuilder", new Class[0]);
            this.body = (GeneratedMessageV3.Builder)m.invoke(null, new Object[0]);
            this.body.mergeFrom((InputStream)ms);
            this.payload.write(data, ms.getPosition(), ms.available());
            this.payload.seek(0L, SeekOrigin.BEGIN);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug(e);
        }
    }

    public SteammessagesBase.CMsgProtoBufHeader.Builder getProtoHeader() {
        return ((MsgGCHdrProtoBuf)this.getHeader()).getProto();
    }

    public BodyType getBody() {
        return this.body;
    }
}

