/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgHdrProtoBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PacketClientMsgProtobuf
implements IPacketMsg {
    private EMsg msgType;
    private long targetJobID;
    private long sourceJobID;
    private byte[] payload;

    public PacketClientMsgProtobuf(EMsg eMsg, byte[] data) throws IOException {
        this.msgType = eMsg;
        this.payload = data;
        MsgHdrProtoBuf protobufHeader = new MsgHdrProtoBuf();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
            protobufHeader.deserialize(stream);
        }
        this.targetJobID = protobufHeader.getProto().getJobidTarget();
        this.sourceJobID = protobufHeader.getProto().getJobidSource();
    }

    @Override
    public boolean isProto() {
        return true;
    }

    @Override
    public EMsg getMsgType() {
        return this.msgType;
    }

    @Override
    public long getTargetJobID() {
        return this.targetJobID;
    }

    @Override
    public long getSourceJobID() {
        return this.sourceJobID;
    }

    @Override
    public byte[] getData() {
        return this.payload;
    }
}

