/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.Msg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.generated.MsgChannelEncryptRequest;
import in.dragonbra.javasteam.generated.MsgChannelEncryptResponse;
import in.dragonbra.javasteam.generated.MsgChannelEncryptResult;
import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.DisconnectedEventArgs;
import in.dragonbra.javasteam.networking.steam3.INetFilterEncryption;
import in.dragonbra.javasteam.networking.steam3.NetFilterEncryption;
import in.dragonbra.javasteam.networking.steam3.NetFilterEncryptionWithHMAC;
import in.dragonbra.javasteam.networking.steam3.NetMsgEventArgs;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.CMClient;
import in.dragonbra.javasteam.util.KeyDictionary;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import in.dragonbra.javasteam.util.crypto.RSACrypto;
import in.dragonbra.javasteam.util.event.EventArgs;
import in.dragonbra.javasteam.util.event.EventHandler;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class EnvelopeEncryptedConnection
extends Connection {
    private static final Logger logger = LogManager.getLogger(EnvelopeEncryptedConnection.class);
    private final Connection inner;
    private final EUniverse universe;
    private EncryptionState state;
    private INetFilterEncryption encryption;
    private final EventHandler<EventArgs> onConnected = new EventHandler<EventArgs>(){

        @Override
        public void handleEvent(Object sender, EventArgs e) {
            EnvelopeEncryptedConnection.this.state = EncryptionState.CONNECTED;
        }
    };
    private final EventHandler<DisconnectedEventArgs> onDisconnected = new EventHandler<DisconnectedEventArgs>(){

        @Override
        public void handleEvent(Object sender, DisconnectedEventArgs e) {
            EnvelopeEncryptedConnection.this.state = EncryptionState.DISCONNECTED;
            EnvelopeEncryptedConnection.this.encryption = null;
            EnvelopeEncryptedConnection.this.disconnected.handleEvent(EnvelopeEncryptedConnection.this, e);
        }
    };
    private final EventHandler<NetMsgEventArgs> onNetMsgReceived = new EventHandler<NetMsgEventArgs>(){

        @Override
        public void handleEvent(Object sender, NetMsgEventArgs e) {
            if (EnvelopeEncryptedConnection.this.state == EncryptionState.ENCRYPTED) {
                byte[] plaintextData = EnvelopeEncryptedConnection.this.encryption.processIncoming(e.getData());
                EnvelopeEncryptedConnection.this.netMsgReceived.handleEvent(EnvelopeEncryptedConnection.this, e.withData(plaintextData));
                return;
            }
            IPacketMsg packetMsg = CMClient.getPacketMsg(e.getData());
            if (!EnvelopeEncryptedConnection.this.isExpectedEMsg(packetMsg.getMsgType())) {
                logger.debug("Rejected EMsg: " + (Object)((Object)packetMsg.getMsgType()) + " during channel setup");
                return;
            }
            switch (packetMsg.getMsgType()) {
                case ChannelEncryptRequest: {
                    EnvelopeEncryptedConnection.this.handleEncryptRequest(packetMsg);
                    break;
                }
                case ChannelEncryptResult: {
                    EnvelopeEncryptedConnection.this.handleEncryptResult(packetMsg);
                }
            }
        }
    };

    public EnvelopeEncryptedConnection(Connection inner, EUniverse universe) {
        if (inner == null) {
            throw new IllegalArgumentException("inner connection is null");
        }
        this.inner = inner;
        this.universe = universe;
        inner.getNetMsgReceived().addEventHandler(this.onNetMsgReceived);
        inner.getConnected().addEventHandler(this.onConnected);
        inner.getDisconnected().addEventHandler(this.onDisconnected);
    }

    private void handleEncryptRequest(IPacketMsg packetMsg) {
        byte[] publicKey;
        Msg<MsgChannelEncryptRequest> request = new Msg<MsgChannelEncryptRequest>(MsgChannelEncryptRequest.class, packetMsg);
        EUniverse connectedUniverse = request.getBody().getUniverse();
        long protoVersion = request.getBody().getProtocolVersion();
        logger.debug("Got encryption request. Universe: " + (Object)((Object)connectedUniverse) + " Protocol ver: " + protoVersion);
        if (protoVersion != 1L) {
            logger.debug("Encryption handshake protocol version mismatch!");
        }
        if (connectedUniverse != this.universe) {
            logger.debug("Expected universe " + (Object)((Object)this.universe) + " but server reported universe " + (Object)((Object)connectedUniverse));
        }
        byte[] randomChallenge = null;
        if (request.getPayload().getLength() >= 16L) {
            randomChallenge = request.getPayload().toByteArray();
        }
        if ((publicKey = KeyDictionary.getPublicKey(connectedUniverse)) == null) {
            logger.debug("HandleEncryptRequest got request for invalid universe! Universe: " + (Object)((Object)connectedUniverse) + " Protocol ver: " + protoVersion);
            this.disconnect();
        }
        Msg<MsgChannelEncryptResponse> response = new Msg<MsgChannelEncryptResponse>(MsgChannelEncryptResponse.class);
        byte[] tempSessionKey = CryptoHelper.generateRandomBlock(32);
        byte[] encryptedHandshakeBlob = null;
        RSACrypto rsa = new RSACrypto(publicKey);
        if (randomChallenge != null) {
            byte[] blobToEncrypt = new byte[tempSessionKey.length + randomChallenge.length];
            System.arraycopy(tempSessionKey, 0, blobToEncrypt, 0, tempSessionKey.length);
            System.arraycopy(randomChallenge, 0, blobToEncrypt, tempSessionKey.length, randomChallenge.length);
            encryptedHandshakeBlob = rsa.encrypt(blobToEncrypt);
        } else {
            encryptedHandshakeBlob = rsa.encrypt(tempSessionKey);
        }
        byte[] keyCrc = CryptoHelper.crcHash(encryptedHandshakeBlob);
        try {
            response.write(encryptedHandshakeBlob);
            response.write(keyCrc);
            response.write(0);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.encryption = randomChallenge != null ? new NetFilterEncryptionWithHMAC(tempSessionKey) : new NetFilterEncryption(tempSessionKey);
        this.state = EncryptionState.CHALLENGED;
        this.send(response.serialize());
    }

    private void handleEncryptResult(IPacketMsg packetMsg) {
        Msg<MsgChannelEncryptResult> result = new Msg<MsgChannelEncryptResult>(MsgChannelEncryptResult.class, packetMsg);
        logger.debug("Encryption result: " + (Object)((Object)result.getBody().getResult()));
        assert (this.encryption != null);
        if (result.getBody().getResult() == EResult.OK && this.encryption != null) {
            this.state = EncryptionState.ENCRYPTED;
            this.connected.handleEvent(this, EventArgs.EMPTY);
        } else {
            logger.debug("Encryption channel setup failed");
            this.disconnect();
        }
    }

    private boolean isExpectedEMsg(EMsg msg) {
        switch (this.state) {
            case DISCONNECTED: {
                return false;
            }
            case CONNECTED: {
                return msg == EMsg.ChannelEncryptRequest;
            }
            case CHALLENGED: {
                return msg == EMsg.ChannelEncryptResult;
            }
            case ENCRYPTED: {
                return true;
            }
        }
        throw new IllegalStateException("Unreachable - landed up in undefined state.");
    }

    @Override
    public void connect(InetSocketAddress endPoint, int timeout) {
        this.inner.connect(endPoint, timeout);
    }

    @Override
    public void disconnect() {
        this.inner.disconnect();
    }

    @Override
    public void send(byte[] data) {
        if (this.state == EncryptionState.ENCRYPTED) {
            data = this.encryption.processOutgoing(data);
        }
        this.inner.send(data);
    }

    @Override
    public InetAddress getLocalIP() {
        return this.inner.getLocalIP();
    }

    @Override
    public InetSocketAddress getCurrentEndPoint() {
        return this.inner.getCurrentEndPoint();
    }

    @Override
    public ProtocolTypes getProtocolTypes() {
        return this.inner.getProtocolTypes();
    }

    private static enum EncryptionState {
        DISCONNECTED,
        CONNECTED,
        CHALLENGED,
        ENCRYPTED;

    }
}

