/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.enums.EUdpPacketType;
import in.dragonbra.javasteam.generated.ChallengeData;
import in.dragonbra.javasteam.generated.ConnectData;
import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.NetMsgEventArgs;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.networking.steam3.UdpPacket;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class UdpConnection
extends Connection {
    private static final Logger logger = LogManager.getLogger(UdpConnection.class);
    private static final long RESEND_DELAY = 3000L;
    private static final long TIMEOUT_DELAY = 60000L;
    private static final int RESEND_COUNT = 3;
    private static final int AHEAD_COUNT = 3;
    private volatile AtomicReference<State> state;
    private Thread netThread;
    private NetLoop netLoop;
    private DatagramSocket sock;
    private long timeout;
    private long nextResend;
    private static int SOURCE_CONN_ID = 512;
    private int remoteConnId;
    private int outSeq;
    private int outSeqSent;
    private int outSeqAcked;
    private int inSeq;
    private int inSeqAcked;
    private int inSeqHandled;
    private final List<UdpPacket> outPackets = new ArrayList<UdpPacket>();
    private Map<Integer, UdpPacket> inPackets;
    private InetSocketAddress currentEndPoint;

    public UdpConnection() {
        try {
            this.sock = new DatagramSocket();
        }
        catch (SocketException e) {
            throw new IllegalStateException("couldn't create datagram socket", e);
        }
        this.state = new AtomicReference<State>(State.DISCONNECTED);
    }

    @Override
    public void connect(InetSocketAddress endPoint, int timeout) {
        this.outPackets.clear();
        this.inPackets = new HashMap<Integer, UdpPacket>();
        this.currentEndPoint = null;
        this.remoteConnId = 0;
        this.outSeq = 1;
        this.outSeqSent = 0;
        this.outSeqAcked = 0;
        this.inSeq = 0;
        this.inSeqAcked = 0;
        this.inSeqHandled = 0;
        logger.debug("connecting to " + endPoint);
        this.netLoop = new NetLoop(endPoint);
        this.netThread = new Thread((Runnable)this.netLoop, "UdpConnection Thread");
        this.netThread.start();
    }

    @Override
    public void disconnect() {
        if (this.netThread == null) {
            return;
        }
        if (this.state.get() != State.DISCONNECTED && this.state.getAndSet(State.DISCONNECTING) == State.DISCONNECTED) {
            this.state.set(State.DISCONNECTED);
        }
        if (this.state.get() == State.DISCONNECTING) {
            this.sendSequenced(new UdpPacket(EUdpPacketType.Disconnect));
        }
        SOURCE_CONN_ID += 256;
        this.onDisconnected(true);
    }

    @Override
    public void send(byte[] data) {
        if (this.state.get() == State.CONNECTED) {
            this.sendData(new MemoryStream(data));
        }
    }

    @Override
    public InetAddress getLocalIP() {
        return this.sock.getLocalAddress();
    }

    @Override
    public InetSocketAddress getCurrentEndPoint() {
        return this.currentEndPoint;
    }

    @Override
    public ProtocolTypes getProtocolTypes() {
        return ProtocolTypes.UDP;
    }

    private void sendData(MemoryStream ms) {
        UdpPacket[] packets = new UdpPacket[(int)(ms.getLength() / 1244L + 1L)];
        for (int i = 0; i < packets.length; ++i) {
            long index = i * 1244;
            long length = Math.min(1244L, ms.getLength() - index);
            packets[i] = new UdpPacket(EUdpPacketType.Data, ms, length);
            packets[i].getHeader().setMsgSize((int)ms.getLength());
        }
        this.sendSequenced(packets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSequenced(UdpPacket packet) {
        List<UdpPacket> list = this.outPackets;
        synchronized (list) {
            packet.getHeader().setSeqThis(this.outSeq);
            packet.getHeader().setMsgStartSeq(this.outSeq);
            packet.getHeader().setPacketsInMsg(1);
            this.outPackets.add(packet);
            ++this.outSeq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSequenced(UdpPacket[] packets) {
        List<UdpPacket> list = this.outPackets;
        synchronized (list) {
            int msgStart = this.outSeq;
            for (UdpPacket packet : packets) {
                this.sendSequenced(packet);
                packet.getHeader().setPacketsInMsg(packets.length);
                packet.getHeader().setMsgStartSeq(msgStart);
            }
        }
    }

    private void sendPacket(UdpPacket packet) {
        packet.getHeader().setSourceConnID(SOURCE_CONN_ID);
        packet.getHeader().setDestConnID(this.remoteConnId);
        this.inSeqAcked = this.inSeq;
        packet.getHeader().setSeqAck(this.inSeqAcked);
        logger.debug(String.format("Sent -> %s Seq %d Ack %d; %d bytes; Message: %d bytes %d packets", new Object[]{packet.getHeader().getPacketType(), packet.getHeader().getSeqThis(), packet.getHeader().getSeqAck(), packet.getHeader().getPayloadSize(), packet.getHeader().getMsgSize(), packet.getHeader().getPacketsInMsg()}));
        byte[] data = packet.getData();
        try {
            this.sock.send(new DatagramPacket(data, 0, data.length, this.currentEndPoint.getAddress(), this.currentEndPoint.getPort()));
        }
        catch (IOException e) {
            logger.debug("Critical socket failure", e);
            this.state.set(State.DISCONNECTING);
            return;
        }
        if (this.outSeqSent == this.outSeqAcked) {
            this.nextResend = System.currentTimeMillis() + 3000L;
        }
        if (packet.getHeader().getSeqThis() > 0) {
            this.outSeqSent = packet.getHeader().getSeqThis();
        }
    }

    private void sendAck() {
        this.sendPacket(new UdpPacket(EUdpPacketType.Datagram));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingMessages() {
        List<UdpPacket> list = this.outPackets;
        synchronized (list) {
            if (System.currentTimeMillis() > this.nextResend && this.outSeqSent > this.outSeqAcked) {
                if (this.state.get() == State.DISCONNECTING) {
                    this.outPackets.clear();
                }
                logger.debug("Sequenced packet resend required");
                for (int i = 0; i < 3 && i < this.outPackets.size(); ++i) {
                    this.sendPacket(this.outPackets.get(i));
                }
                this.nextResend = System.currentTimeMillis() + 3000L;
            } else if (this.outSeqSent < this.outSeqAcked + 3) {
                for (int i = this.outSeqSent - this.outSeqAcked; i < 3 && i < this.outPackets.size(); ++i) {
                    this.sendPacket(this.outPackets.get(i));
                }
            }
        }
    }

    private int readyMessageParts() {
        UdpPacket packet = this.inPackets.get(this.inSeqHandled + 1);
        if (packet == null) {
            return 0;
        }
        for (int i = 1; i < packet.getHeader().getPacketsInMsg(); ++i) {
            if (this.inPackets.containsKey(this.inSeqHandled + 1 + i)) continue;
            return 0;
        }
        return packet.getHeader().getPacketsInMsg();
    }

    private boolean dispatchMessage() {
        int numPackets = this.readyMessageParts();
        if (numPackets == 0) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < numPackets; ++i) {
            UdpPacket packet = this.inPackets.get(++this.inSeqHandled);
            this.inPackets.remove(this.inSeqHandled);
            try {
                baos.write(packet.getPayload().toByteArray());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byte[] data = baos.toByteArray();
        logger.debug("Dispatchin message: " + data.length + " bytes");
        this.onNetMsgReceived(new NetMsgEventArgs(data, this.currentEndPoint));
        return true;
    }

    private void receivePacket(UdpPacket packet) {
        if (!packet.isValid()) {
            return;
        }
        if (this.remoteConnId > 0 && packet.getHeader().getSourceConnID() != this.remoteConnId) {
            return;
        }
        logger.debug(String.format("<- Recv'd %s Seq %d Ack %d; %d bytes; Message: %d bytes %d packets", new Object[]{packet.getHeader().getPacketType(), packet.getHeader().getSeqThis(), packet.getHeader().getSeqAck(), packet.getHeader().getPayloadSize(), packet.getHeader().getMsgSize(), packet.getHeader().getPacketsInMsg()}));
        if (packet.getHeader().getPacketType() == EUdpPacketType.Data && packet.getHeader().getSeqThis() < this.inSeq) {
            this.sendAck();
            return;
        }
        if (this.outSeqAcked < packet.getHeader().getSeqAck()) {
            this.outSeqAcked = packet.getHeader().getSeqAck();
            if (this.outSeqSent < this.outSeqAcked) {
                this.outSeqSent = this.outSeqAcked;
            }
            Iterator<UdpPacket> iter = this.outPackets.iterator();
            while (iter.hasNext()) {
                if (iter.next().getHeader().getSeqThis() > this.outSeqAcked) continue;
                iter.remove();
            }
            this.nextResend = System.currentTimeMillis() + 3000L;
        }
        if (packet.getHeader().getSeqThis() == this.inSeq + 1) {
            do {
                ++this.inSeq;
            } while (this.inPackets.containsKey(this.inSeq + 1));
        }
        switch (packet.getHeader().getPacketType()) {
            case Challenge: {
                this.receiveChallenge(packet);
                break;
            }
            case Accept: {
                this.receiveAccept(packet);
                break;
            }
            case Data: {
                this.receiveData(packet);
                break;
            }
            case Disconnect: {
                logger.debug("Disconnected by server");
                this.state.set(State.DISCONNECTED);
                return;
            }
            case Datagram: {
                break;
            }
            default: {
                logger.debug("Received unexpected packet type " + (Object)((Object)packet.getHeader().getPacketType()));
            }
        }
    }

    private void receiveChallenge(UdpPacket packet) {
        if (!this.state.compareAndSet(State.CHALLENGE_REQ_SENT, State.CONNECT_SENT)) {
            return;
        }
        try {
            ChallengeData cr = new ChallengeData();
            cr.deserialize(packet.getPayload());
            ConnectData cd = new ConnectData();
            cd.setChallengeValue(cr.getChallengeValue() ^ 0xA426DF2B);
            MemoryStream ms = new MemoryStream();
            cd.serialize(ms.asOutputStream());
            ms.seek(0L, SeekOrigin.BEGIN);
            this.sendSequenced(new UdpPacket(EUdpPacketType.Connect, ms));
            this.inSeqHandled = packet.getHeader().getSeqThis();
        }
        catch (IOException e) {
            logger.debug(e);
        }
    }

    private void receiveAccept(UdpPacket packet) {
        if (!this.state.compareAndSet(State.CONNECT_SENT, State.CONNECTED)) {
            return;
        }
        logger.debug("Connection established");
        this.remoteConnId = packet.getHeader().getSourceConnID();
        this.inSeqHandled = packet.getHeader().getSeqThis();
        this.onConnected();
    }

    private void receiveData(UdpPacket packet) {
        if (this.state.get() != State.CONNECTED && this.state.get() != State.DISCONNECTING) {
            return;
        }
        if (packet.getHeader().getSeqThis() <= this.inSeqHandled || this.inPackets.containsKey(packet.getHeader().getSeqThis())) {
            return;
        }
        this.inPackets.put(packet.getHeader().getSeqThis(), packet);
        while (this.dispatchMessage()) {
        }
    }

    private static enum State {
        DISCONNECTED,
        CHALLENGE_REQ_SENT,
        CONNECT_SENT,
        CONNECTED,
        DISCONNECTING;

    }

    private class NetLoop
    implements Runnable {
        NetLoop(InetSocketAddress endPoint) {
            UdpConnection.this.currentEndPoint = endPoint;
        }

        @Override
        public void run() {
            boolean userRequestDisconnect = false;
            byte[] buf = new byte[2048];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            boolean received = false;
            try {
                UdpConnection.this.sock.setSoTimeout(150);
            }
            catch (SocketException e) {
                logger.debug(e);
            }
            if (UdpConnection.this.currentEndPoint != null) {
                UdpConnection.this.timeout = System.currentTimeMillis() + 60000L;
                UdpConnection.this.nextResend = System.currentTimeMillis() + 3000L;
                if (!UdpConnection.this.state.compareAndSet(State.DISCONNECTED, State.CHALLENGE_REQ_SENT)) {
                    UdpConnection.this.state.set(State.DISCONNECTING);
                    userRequestDisconnect = true;
                } else {
                    UdpConnection.this.sendPacket(new UdpPacket(EUdpPacketType.ChallengeReq));
                }
            }
            while (UdpConnection.this.state.get() != State.DISCONNECTED) {
                try {
                    block16: {
                        try {
                            UdpConnection.this.sock.receive(packet);
                            received = true;
                        }
                        catch (SocketTimeoutException e) {
                            if (System.currentTimeMillis() <= UdpConnection.this.timeout) break block16;
                            logger.debug("Connection timed out", e);
                            UdpConnection.this.state.set(State.DISCONNECTED);
                            break;
                        }
                    }
                    UdpConnection.this.sock.setSoTimeout(10);
                    while (received) {
                        if (!packet.getAddress().equals(UdpConnection.this.currentEndPoint.getAddress()) && packet.getPort() != packet.getPort()) continue;
                        UdpConnection.this.timeout = System.currentTimeMillis() + 60000L;
                        MemoryStream ms = new MemoryStream(packet.getData());
                        UdpPacket udpPacket = new UdpPacket(ms);
                        UdpConnection.this.receivePacket(udpPacket);
                        try {
                            UdpConnection.this.sock.receive(packet);
                            received = true;
                        }
                        catch (SocketTimeoutException e) {
                            received = false;
                        }
                    }
                }
                catch (IOException e) {
                    logger.debug("Exception while reading packer", e);
                    UdpConnection.this.state.set(State.DISCONNECTED);
                    break;
                }
                if (UdpConnection.this.state.get() != State.DISCONNECTED) {
                    UdpConnection.this.sendPendingMessages();
                }
                if (UdpConnection.this.inSeq != UdpConnection.this.inSeqAcked) {
                    UdpConnection.this.sendAck();
                }
                if (UdpConnection.this.state.get() != State.DISCONNECTING || !UdpConnection.this.outPackets.isEmpty()) continue;
                logger.debug("Graceful disconnect completed");
                UdpConnection.this.state.set(State.DISCONNECTED);
                userRequestDisconnect = true;
                break;
            }
            if (UdpConnection.this.sock != null) {
                UdpConnection.this.sock.close();
            }
            logger.debug("Calling onDisconnected");
            UdpConnection.this.onDisconnected(userRequestDisconnect);
        }
    }
}

