/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import java.net.InetSocketAddress;
import java.util.EnumSet;

public class ServerRecord {
    private InetSocketAddress endpoint;
    private EnumSet<ProtocolTypes> protocolTypes;

    ServerRecord(InetSocketAddress endpoint, ProtocolTypes protocolTypes) {
        this(endpoint, EnumSet.of(protocolTypes));
    }

    private ServerRecord(InetSocketAddress endpoint, EnumSet<ProtocolTypes> protocolTypes) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint is null");
        }
        this.endpoint = endpoint;
        this.protocolTypes = protocolTypes;
    }

    public String getHost() {
        return this.endpoint.getHostString();
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public EnumSet<ProtocolTypes> getProtocolTypes() {
        return this.protocolTypes;
    }

    public static ServerRecord createServer(String host, int port, ProtocolTypes protocolTypes) {
        return ServerRecord.createServer(host, port, EnumSet.of(protocolTypes));
    }

    public static ServerRecord createServer(String host, int port, EnumSet<ProtocolTypes> protocolTypes) {
        return new ServerRecord(new InetSocketAddress(host, port), protocolTypes);
    }

    public static ServerRecord createSocketServer(InetSocketAddress endpoint) {
        return new ServerRecord(endpoint, EnumSet.of(ProtocolTypes.TCP, ProtocolTypes.UDP));
    }

    public static ServerRecord createWebSocketServer(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        int defaultPort = 443;
        String[] split = address.split(":");
        InetSocketAddress endpoint = split.length > 1 ? new InetSocketAddress(split[0], Integer.parseInt(split[1])) : new InetSocketAddress(address, 443);
        return new ServerRecord(endpoint, ProtocolTypes.WEB_SOCKET);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServerRecord)) {
            return false;
        }
        ServerRecord o = (ServerRecord)obj;
        return this.endpoint.equals(o.endpoint) && this.protocolTypes.equals(o.protocolTypes);
    }

    public int hashCode() {
        return this.endpoint.hashCode() ^ this.protocolTypes.hashCode();
    }
}

