/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;

public class PICSProductInfo
extends CallbackMsg {
    private int id;
    private int changeNumber;
    private boolean missingToken;
    private byte[] shaHash;
    private KeyValue keyValues;
    private boolean onlyPublic;
    private boolean useHttp;
    private URI httpUri;

    public PICSProductInfo(SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.Builder parentResponse, SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.AppInfo appInfo) {
        this.id = appInfo.getAppid();
        this.changeNumber = appInfo.getChangeNumber();
        this.missingToken = appInfo.getMissingToken();
        this.shaHash = appInfo.getSha().toByteArray();
        this.keyValues = new KeyValue();
        if (appInfo.hasBuffer() && !appInfo.getBuffer().isEmpty()) {
            try (MemoryStream ms = new MemoryStream(appInfo.getBuffer().toByteArray(), 0, appInfo.getBuffer().size() - 1);){
                this.keyValues.readAsText(ms);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to read buffer", e);
            }
        }
        this.onlyPublic = appInfo.getOnlyPublic();
        if (this.shaHash != null && this.shaHash.length > 0 && !Strings.isNullOrEmpty(parentResponse.getHttpHost())) {
            String shaString = Strings.toHex(this.shaHash).replace("-", "").toLowerCase();
            String uriString = String.format("http://%s/appinfo/%d/sha/%s.txt.gz", parentResponse.getHttpHost(), this.id, shaString);
            this.httpUri = URI.create(uriString);
        }
        this.useHttp = this.httpUri != null && appInfo.getSize() >= parentResponse.getHttpMinSize();
    }

    public PICSProductInfo(SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.PackageInfo packageInfo) {
        this.id = packageInfo.getPackageid();
        this.changeNumber = packageInfo.getChangeNumber();
        this.missingToken = packageInfo.getMissingToken();
        this.shaHash = packageInfo.getSha().toByteArray();
        this.keyValues = new KeyValue();
        if (packageInfo.hasBuffer()) {
            try (BinaryReader br = new BinaryReader(new ByteArrayInputStream(packageInfo.getBuffer().toByteArray()));){
                br.readInt();
                this.keyValues.tryReadAsBinary(br);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to read buffer", e);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public boolean isMissingToken() {
        return this.missingToken;
    }

    public byte[] getShaHash() {
        return this.shaHash;
    }

    public KeyValue getKeyValues() {
        return this.keyValues;
    }

    public boolean isOnlyPublic() {
        return this.onlyPublic;
    }

    public boolean isUseHttp() {
        return this.useHttp;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }
}

