/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgClientUpdateGuestPassesList;
import in.dragonbra.javasteam.generated.MsgClientVACBanStatus;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.handlers.steamapps.PICSRequest;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.AppOwnershipTicketCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.CDNAuthTokenCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.CheckAppBetaPasswordCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.DepotKeyCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.FreeLicenseCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.GameConnectTokensCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.GuestPassListCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.LicenseListCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PICSChangesCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PICSProductInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PICSTokensCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.VACStatusCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamApps
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamApps() {
        this.dispatchMap.put(EMsg.ClientLicenseList, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleLicenseList(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientRequestFreeLicenseResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleFreeLicense(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientGameConnectTokens, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleGameConnectTokens(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientVACBanStatus, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleVACBanStatus(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientGetAppOwnershipTicketResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleAppOwnershipTicketResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientGetDepotDecryptionKeyResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleDepotKeyResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientPICSAccessTokenResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handlePICSAccessTokenResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientPICSChangesSinceResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handlePICSChangesSinceResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientPICSProductInfoResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handlePICSProductInfoResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientUpdateGuestPassesList, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleGuestPassList(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientGetCDNAuthTokenResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleCDNAuthTokenResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientCheckAppBetaPasswordResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamApps.this.handleCheckAppBetaPasswordResponse(packetMsg);
            }
        });
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID getAppOwnershipTicket(int appId) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientGetAppOwnershipTicket.class, EMsg.ClientGetAppOwnershipTicket);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver.CMsgClientGetAppOwnershipTicket.Builder)request.getBody()).setAppId(appId);
        this.client.send(request);
        return jobID;
    }

    public JobID getDepotDecryptionKey(int depotId, int appId) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetDepotDecryptionKey.class, EMsg.ClientGetDepotDecryptionKey);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientGetDepotDecryptionKey.Builder)request.getBody()).setDepotId(depotId);
        ((SteammessagesClientserver2.CMsgClientGetDepotDecryptionKey.Builder)request.getBody()).setAppId(appId);
        this.client.send(request);
        return jobID;
    }

    public JobID picsGetAccessTokens(Integer app, Integer _package) {
        ArrayList<Integer> apps = new ArrayList<Integer>();
        ArrayList<Integer> packages = new ArrayList<Integer>();
        if (app != null) {
            apps.add(app);
        }
        if (_package != null) {
            packages.add(_package);
        }
        return this.picsGetAccessTokens(apps, packages);
    }

    public JobID picsGetAccessTokens(Iterable<Integer> appIds, Iterable<Integer> packageIds) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenRequest.class, EMsg.ClientPICSAccessTokenRequest);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenRequest.Builder)request.getBody()).addAllAppids(appIds);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenRequest.Builder)request.getBody()).addAllPackageids(packageIds);
        this.client.send(request);
        return jobID;
    }

    public JobID picsGetChangesSince() {
        return this.picsGetChangesSince(0, true, false);
    }

    public JobID picsGetChangesSince(int lastChangeNumber) {
        return this.picsGetChangesSince(lastChangeNumber, true, false);
    }

    public JobID picsGetChangesSince(int lastChangeNumber, boolean sendAppChangeList) {
        return this.picsGetChangesSince(lastChangeNumber, sendAppChangeList, false);
    }

    public JobID picsGetChangesSince(int lastChangeNumber, boolean sendAppChangeList, boolean sendPackageChangelist) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.class, EMsg.ClientPICSChangesSinceRequest);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.Builder)request.getBody()).setSinceChangeNumber(lastChangeNumber);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.Builder)request.getBody()).setSendAppInfoChanges(sendAppChangeList);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.Builder)request.getBody()).setSendPackageInfoChanges(sendPackageChangelist);
        this.client.send(request);
        return jobID;
    }

    public JobID picsGetProductInfo(Integer app, Integer _package) {
        return this.picsGetProductInfo(app, _package, true, false);
    }

    public JobID picsGetProductInfo(Integer app, Integer _package, boolean onlyPublic) {
        return this.picsGetProductInfo(app, _package, onlyPublic, false);
    }

    public JobID picsGetProductInfo(Integer app, Integer _package, boolean onlyPublic, boolean metaDataOnly) {
        ArrayList<Integer> apps = new ArrayList<Integer>();
        ArrayList<Integer> packages = new ArrayList<Integer>();
        if (app != null) {
            apps.add(app);
        }
        if (_package != null) {
            packages.add(_package);
        }
        return this.picsGetProductInfo(apps, packages, onlyPublic, metaDataOnly);
    }

    public JobID picsGetProductInfo(Iterable<Integer> apps, Iterable<Integer> packages) {
        return this.picsGetProductInfo(apps, packages, true, false);
    }

    public JobID picsGetProductInfo(Iterable<Integer> apps, Iterable<Integer> packages, boolean onlyPublic, boolean metaDataOnly) {
        ArrayList<PICSRequest> appRequests = new ArrayList<PICSRequest>();
        ArrayList<PICSRequest> packageRequests = new ArrayList<PICSRequest>();
        for (Integer app : apps) {
            appRequests.add(new PICSRequest(app, 0L, onlyPublic));
        }
        for (Integer _package : packages) {
            packageRequests.add(new PICSRequest(_package, 0L, onlyPublic));
        }
        return this.picsGetProductInfo(appRequests, packageRequests, metaDataOnly);
    }

    public JobID picsGetProductInfo(Iterable<PICSRequest> apps, Iterable<PICSRequest> packages, boolean metaDataOnly) {
        if (apps == null) {
            throw new IllegalArgumentException("apps is null");
        }
        if (packages == null) {
            throw new IllegalArgumentException("packages is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.class, EMsg.ClientPICSProductInfoRequest);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        for (PICSRequest appRequest : apps) {
            SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.AppInfo.Builder appInfo = SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.AppInfo.newBuilder();
            appInfo.setAccessToken(appRequest.getAccessToken());
            appInfo.setAppid(appRequest.getId());
            appInfo.setOnlyPublicObsolete(appRequest.isPublic());
            ((SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.Builder)request.getBody()).addApps(appInfo);
        }
        for (PICSRequest packageRequest : packages) {
            SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.PackageInfo.Builder packageInfo = SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.PackageInfo.newBuilder();
            packageInfo.setAccessToken(packageRequest.getAccessToken());
            packageInfo.setPackageid(packageRequest.getId());
            ((SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.Builder)request.getBody()).addPackages(packageInfo);
        }
        ((SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.Builder)request.getBody()).setMetaDataOnly(metaDataOnly);
        this.client.send(request);
        return jobID;
    }

    public JobID getCDNAuthToken(int app, int depot, String hostName) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetCDNAuthToken.class, EMsg.ClientGetCDNAuthToken);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientGetCDNAuthToken.Builder)request.getBody()).setAppId(app);
        ((SteammessagesClientserver2.CMsgClientGetCDNAuthToken.Builder)request.getBody()).setDepotId(depot);
        ((SteammessagesClientserver2.CMsgClientGetCDNAuthToken.Builder)request.getBody()).setHostName(hostName);
        this.client.send(request);
        return jobID;
    }

    public JobID requestFreeLicense(int app) {
        ArrayList<Integer> apps = new ArrayList<Integer>();
        apps.add(app);
        return this.requestFreeLicense(apps);
    }

    public JobID requestFreeLicense(Iterable<Integer> apps) {
        if (apps == null) {
            throw new IllegalArgumentException("apps is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestFreeLicense.class, EMsg.ClientRequestFreeLicense);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientRequestFreeLicense.Builder)request.getBody()).addAllAppids(apps);
        this.client.send(request);
        return jobID;
    }

    public JobID checkAppBetaPassword(int app, String password) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientCheckAppBetaPassword.class, EMsg.ClientCheckAppBetaPassword);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientCheckAppBetaPassword.Builder)request.getBody()).setAppId(app);
        ((SteammessagesClientserver2.CMsgClientCheckAppBetaPassword.Builder)request.getBody()).setBetapassword(password);
        this.client.send(request);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleAppOwnershipTicketResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf ticketResponse = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientGetAppOwnershipTicketResponse.class, packetMsg);
        this.client.postCallback(new AppOwnershipTicketCallback(ticketResponse.getTargetJobID(), (SteammessagesClientserver.CMsgClientGetAppOwnershipTicketResponse.Builder)ticketResponse.getBody()));
    }

    private void handleDepotKeyResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf keyResponse = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetDepotDecryptionKeyResponse.class, packetMsg);
        this.client.postCallback(new DepotKeyCallback(keyResponse.getTargetJobID(), (SteammessagesClientserver2.CMsgClientGetDepotDecryptionKeyResponse.Builder)keyResponse.getBody()));
    }

    private void handleGameConnectTokens(IPacketMsg packetMsg) {
        ClientMsgProtobuf gcTokens = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientGameConnectTokens.class, packetMsg);
        this.client.postCallback(new GameConnectTokensCallback((SteammessagesClientserver.CMsgClientGameConnectTokens.Builder)gcTokens.getBody()));
    }

    private void handleLicenseList(IPacketMsg packetMsg) {
        ClientMsgProtobuf licenseList = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientLicenseList.class, packetMsg);
        this.client.postCallback(new LicenseListCallback((SteammessagesClientserver.CMsgClientLicenseList.Builder)licenseList.getBody()));
    }

    private void handleFreeLicense(IPacketMsg packetMsg) {
        ClientMsgProtobuf grantedLicenses = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestFreeLicenseResponse.class, packetMsg);
        this.client.postCallback(new FreeLicenseCallback(grantedLicenses.getTargetJobID(), (SteammessagesClientserver2.CMsgClientRequestFreeLicenseResponse.Builder)grantedLicenses.getBody()));
    }

    private void handleVACBanStatus(IPacketMsg packetMsg) {
        ClientMsg<MsgClientVACBanStatus> vacStatus = new ClientMsg<MsgClientVACBanStatus>(MsgClientVACBanStatus.class, packetMsg);
        this.client.postCallback(new VACStatusCallback(vacStatus.getBody(), vacStatus.getPayload().toByteArray()));
    }

    private void handlePICSAccessTokenResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf tokensResponse = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.class, packetMsg);
        this.client.postCallback(new PICSTokensCallback(tokensResponse.getTargetJobID(), (SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.Builder)tokensResponse.getBody()));
    }

    private void handlePICSChangesSinceResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf changesResponse = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.class, packetMsg);
        this.client.postCallback(new PICSChangesCallback(changesResponse.getTargetJobID(), (SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.Builder)changesResponse.getBody()));
    }

    private void handlePICSProductInfoResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf productResponse = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.class, packetMsg);
        this.client.postCallback(new PICSProductInfoCallback(productResponse.getTargetJobID(), (SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.Builder)productResponse.getBody()));
    }

    private void handleGuestPassList(IPacketMsg packetMsg) {
        ClientMsg<MsgClientUpdateGuestPassesList> guestPasses = new ClientMsg<MsgClientUpdateGuestPassesList>(MsgClientUpdateGuestPassesList.class, packetMsg);
        this.client.postCallback(new GuestPassListCallback(guestPasses.getBody(), guestPasses.getPayload()));
    }

    private void handleCDNAuthTokenResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetCDNAuthTokenResponse.class, packetMsg);
        this.client.postCallback(new CDNAuthTokenCallback(response.getTargetJobID(), (SteammessagesClientserver2.CMsgClientGetCDNAuthTokenResponse.Builder)response.getBody()));
    }

    private void handleCheckAppBetaPasswordResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientCheckAppBetaPasswordResponse.class, packetMsg);
        this.client.postCallback(new CheckAppBetaPasswordCallback(response.getTargetJobID(), (SteammessagesClientserver2.CMsgClientCheckAppBetaPasswordResponse.Builder)response.getBody()));
    }
}

