/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.handlers.steamapps.PICSChangeData;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.HashMap;
import java.util.Map;

public class PICSChangesCallback
extends CallbackMsg {
    private int lastChangeNumber;
    private int currentChangeNumber;
    private boolean requiresFullUpdate;
    private boolean requiresFullAppUpdate;
    private boolean requiresFullPackageUpdate;
    private Map<Integer, PICSChangeData> packageChanges;
    private Map<Integer, PICSChangeData> appChanges;

    public PICSChangesCallback(JobID jobID, SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.Builder msg) {
        this.setJobID(jobID);
        this.lastChangeNumber = msg.getSinceChangeNumber();
        this.currentChangeNumber = msg.getCurrentChangeNumber();
        this.requiresFullAppUpdate = msg.getForceFullAppUpdate();
        this.requiresFullPackageUpdate = msg.getForceFullPackageUpdate();
        this.requiresFullUpdate = msg.getForceFullUpdate();
        this.packageChanges = new HashMap<Integer, PICSChangeData>();
        this.appChanges = new HashMap<Integer, PICSChangeData>();
        for (SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.PackageChange packageChange : msg.getPackageChangesList()) {
            this.packageChanges.put(packageChange.getPackageid(), new PICSChangeData(packageChange));
        }
        for (SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.AppChange appChange : msg.getAppChangesList()) {
            this.appChanges.put(appChange.getAppid(), new PICSChangeData(appChange));
        }
    }

    public int getLastChangeNumber() {
        return this.lastChangeNumber;
    }

    public int getCurrentChangeNumber() {
        return this.currentChangeNumber;
    }

    public boolean isRequiresFullUpdate() {
        return this.requiresFullUpdate;
    }

    public boolean isRequiresFullPackageUpdate() {
        return this.requiresFullPackageUpdate;
    }

    public boolean isRequiresFullAppUpdate() {
        return this.requiresFullAppUpdate;
    }

    public Map<Integer, PICSChangeData> getPackageChanges() {
        return this.packageChanges;
    }

    public Map<Integer, PICSChangeData> getAppChanges() {
        return this.appChanges;
    }
}

