/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.handlers.steamapps.PICSProductInfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PICSProductInfoCallback
extends CallbackMsg {
    private boolean metaDataOnly;
    private boolean responsePending;
    private List<Integer> unknownPackages;
    private List<Integer> unknownApps;
    private Map<Integer, PICSProductInfo> apps;
    private Map<Integer, PICSProductInfo> packages;

    public PICSProductInfoCallback(JobID jobID, SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.Builder msg) {
        this.setJobID(jobID);
        this.metaDataOnly = msg.getMetaDataOnly();
        this.responsePending = msg.getResponsePending();
        this.unknownPackages = Collections.unmodifiableList(msg.getUnknownPackageidsList());
        this.unknownApps = Collections.unmodifiableList(msg.getUnknownAppidsList());
        this.apps = new HashMap<Integer, PICSProductInfo>();
        this.packages = new HashMap<Integer, PICSProductInfo>();
        for (SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.PackageInfo packageInfo : msg.getPackagesList()) {
            this.packages.put(packageInfo.getPackageid(), new PICSProductInfo(packageInfo));
        }
        for (SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.AppInfo appInfo : msg.getAppsList()) {
            this.apps.put(appInfo.getAppid(), new PICSProductInfo(msg, appInfo));
        }
    }

    public boolean isMetaDataOnly() {
        return this.metaDataOnly;
    }

    public boolean isResponsePending() {
        return this.responsePending;
    }

    public List<Integer> getUnknownPackages() {
        return this.unknownPackages;
    }

    public List<Integer> getUnknownApps() {
        return this.unknownApps;
    }

    public Map<Integer, PICSProductInfo> getApps() {
        return this.apps;
    }

    public Map<Integer, PICSProductInfo> getPackages() {
        return this.packages;
    }
}

