/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PICSTokensCallback
extends CallbackMsg {
    private List<Integer> packageTokensDenied;
    private List<Integer> appTokensDenied;
    private Map<Integer, Long> packageTokens;
    private Map<Integer, Long> appTokens;

    public PICSTokensCallback(JobID jobID, SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.Builder msg) {
        this.setJobID(jobID);
        this.packageTokensDenied = Collections.unmodifiableList(msg.getPackageDeniedTokensList());
        this.appTokensDenied = Collections.unmodifiableList(msg.getAppDeniedTokensList());
        this.packageTokens = new HashMap<Integer, Long>();
        this.appTokens = new HashMap<Integer, Long>();
        for (SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.PackageToken packageToken : msg.getPackageAccessTokensList()) {
            this.packageTokens.put(packageToken.getPackageid(), packageToken.getAccessToken());
        }
        for (SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.AppToken appToken : msg.getAppAccessTokensList()) {
            this.appTokens.put(appToken.getAppid(), appToken.getAccessToken());
        }
    }

    public List<Integer> getPackageTokensDenied() {
        return this.packageTokensDenied;
    }

    public List<Integer> getAppTokensDenied() {
        return this.appTokensDenied;
    }

    public Map<Integer, Long> getPackageTokens() {
        return this.packageTokens;
    }

    public Map<Integer, Long> getAppTokens() {
        return this.appTokens;
    }
}

