/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.enums.EChatRoomEnterResponse;
import in.dragonbra.javasteam.enums.EChatRoomType;
import in.dragonbra.javasteam.generated.MsgClientChatEnter;
import in.dragonbra.javasteam.steam.handlers.steamfriends.ChatMemberInfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatEnterCallback
extends CallbackMsg {
    private SteamID chatID;
    private SteamID friendID;
    private EChatRoomType chatRoomType;
    private SteamID ownerID;
    private SteamID clanID;
    private byte chatFlags;
    private EChatRoomEnterResponse enterResponse;
    private int numChatMembers;
    private String chatRoomName;
    private List<ChatMemberInfo> chatMembers;

    public ChatEnterCallback(MsgClientChatEnter msg, byte[] payload) {
        this.chatID = msg.getSteamIdChat();
        this.friendID = msg.getSteamIdFriend();
        this.chatRoomType = msg.getChatRoomType();
        this.ownerID = msg.getSteamIdOwner();
        this.clanID = msg.getSteamIdClan();
        this.chatFlags = msg.getChatFlags();
        this.enterResponse = msg.getEnterResponse();
        this.numChatMembers = msg.getNumMembers();
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        try (BinaryReader br = new BinaryReader(bais);){
            this.chatRoomName = br.readNullTermString(Charset.forName("UTF-8"));
            if (this.enterResponse != EChatRoomEnterResponse.Success) {
                return;
            }
            ArrayList<ChatMemberInfo> memberList = new ArrayList<ChatMemberInfo>();
            for (int i = 0; i < this.numChatMembers; ++i) {
                ChatMemberInfo memberInfo = new ChatMemberInfo();
                memberInfo.readFromStream(br);
                memberList.add(memberInfo);
            }
            this.chatMembers = Collections.unmodifiableList(memberList);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SteamID getChatID() {
        return this.chatID;
    }

    public SteamID getFriendID() {
        return this.friendID;
    }

    public EChatRoomType getChatRoomType() {
        return this.chatRoomType;
    }

    public SteamID getOwnerID() {
        return this.ownerID;
    }

    public SteamID getClanID() {
        return this.clanID;
    }

    public byte getChatFlags() {
        return this.chatFlags;
    }

    public EChatRoomEnterResponse getEnterResponse() {
        return this.enterResponse;
    }

    public int getNumChatMembers() {
        return this.numChatMembers;
    }

    public String getChatRoomName() {
        return this.chatRoomName;
    }

    public List<ChatMemberInfo> getChatMembers() {
        return this.chatMembers;
    }
}

