/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.enums.EChatInfoType;
import in.dragonbra.javasteam.enums.EChatMemberStateChange;
import in.dragonbra.javasteam.generated.MsgClientChatMemberInfo;
import in.dragonbra.javasteam.steam.handlers.steamfriends.ChatMemberInfo;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.EnumSet;

public class ChatMemberInfoCallback
extends CallbackMsg {
    private SteamID chatRoomID;
    private EChatInfoType type;
    private StateChangeDetails stateChangeInfo;

    public ChatMemberInfoCallback(MsgClientChatMemberInfo msg, byte[] payload) {
        this.chatRoomID = msg.getSteamIdChat();
        this.type = msg.getType();
        switch (this.type) {
            case StateChange: {
                this.stateChangeInfo = new StateChangeDetails(payload);
            }
        }
    }

    public SteamID getChatRoomID() {
        return this.chatRoomID;
    }

    public EChatInfoType getType() {
        return this.type;
    }

    public StateChangeDetails getStateChangeInfo() {
        return this.stateChangeInfo;
    }

    public static class StateChangeDetails {
        private SteamID chatterActedOn;
        private EnumSet<EChatMemberStateChange> stateChange;
        private SteamID chatterActedBy;
        private ChatMemberInfo memberInfo;

        public StateChangeDetails(byte[] data) {
            try (BinaryReader br = new BinaryReader(new ByteArrayInputStream(data));){
                this.chatterActedOn = new SteamID(br.readLong());
                this.stateChange = EChatMemberStateChange.from(br.readInt());
                this.chatterActedBy = new SteamID(br.readLong());
                if (this.stateChange.contains((Object)EChatMemberStateChange.Entered)) {
                    this.memberInfo = new ChatMemberInfo();
                    this.memberInfo.readFromStream(br);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SteamID getChatterActedOn() {
            return this.chatterActedOn;
        }

        public EnumSet<EChatMemberStateChange> getStateChange() {
            return this.stateChange;
        }

        public SteamID getChatterActedBy() {
            return this.chatterActedBy;
        }

        public ChatMemberInfo getMemberInfo() {
            return this.memberInfo;
        }
    }
}

