/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.enums.EAccountFlags;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.handlers.steamfriends.Event;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class ClanStateCallback
extends CallbackMsg {
    private SteamID clanID;
    private EnumSet<EAccountFlags> accountFlags;
    private boolean chatRoomPrivate;
    private String clanName;
    private byte[] avatarHash;
    private int memberTotalCount;
    private int memberOnlineCount;
    private int memberChattingCount;
    private int memberInGameCount;
    private List<Event> events;
    private List<Event> announcements;

    public ClanStateCallback(SteammessagesClientserver.CMsgClientClanState.Builder msg) {
        this.clanID = new SteamID(msg.getSteamidClan());
        this.accountFlags = EAccountFlags.from(msg.getClanAccountFlags());
        this.chatRoomPrivate = msg.getChatRoomPrivate();
        if (msg.hasNameInfo()) {
            this.clanName = msg.getNameInfo().getClanName();
            this.avatarHash = msg.getNameInfo().getShaAvatar().toByteArray();
        }
        if (msg.hasUserCounts()) {
            this.memberTotalCount = msg.getUserCounts().getMembers();
            this.memberOnlineCount = msg.getUserCounts().getOnline();
            this.memberChattingCount = msg.getUserCounts().getChatting();
            this.memberInGameCount = msg.getUserCounts().getInGame();
        }
        this.events = new ArrayList<Event>();
        for (SteammessagesClientserver.CMsgClientClanState.Event event : msg.getEventsList()) {
            this.events.add(new Event(event));
        }
        this.events = Collections.unmodifiableList(this.events);
        this.announcements = new ArrayList<Event>();
        for (SteammessagesClientserver.CMsgClientClanState.Event event : msg.getAnnouncementsList()) {
            this.announcements.add(new Event(event));
        }
        this.announcements = Collections.unmodifiableList(this.announcements);
    }

    public SteamID getClanID() {
        return this.clanID;
    }

    public EnumSet<EAccountFlags> getAccountFlags() {
        return this.accountFlags;
    }

    public boolean isChatRoomPrivate() {
        return this.chatRoomPrivate;
    }

    public String getClanName() {
        return this.clanName;
    }

    public byte[] getAvatarHash() {
        return this.avatarHash;
    }

    public int getMemberTotalCount() {
        return this.memberTotalCount;
    }

    public int getMemberOnlineCount() {
        return this.memberOnlineCount;
    }

    public int getMemberChattingCount() {
        return this.memberChattingCount;
    }

    public int getMemberInGameCount() {
        return this.memberInGameCount;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<Event> getAnnouncements() {
        return this.announcements;
    }
}

