/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.enums.EAccountType;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.handlers.steamfriends.FriendMessage;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class FriendMsgHistoryCallback
extends CallbackMsg {
    private EResult result;
    private SteamID steamID;
    private List<FriendMessage> messages;

    public FriendMsgHistoryCallback(SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistoryResponse.Builder msg, EUniverse universe) {
        this.result = EResult.from(msg.getSuccess());
        this.steamID = new SteamID(msg.getSteamid());
        ArrayList<FriendMessage> messages = new ArrayList<FriendMessage>();
        for (SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistoryResponse.FriendMessage m : msg.getMessagesList()) {
            SteamID senderID = new SteamID(m.getAccountid(), universe, EAccountType.Individual);
            Date timestamp = new Date((long)m.getTimestamp() * 1000L);
            messages.add(new FriendMessage(senderID, m.getUnread(), m.getMessage(), timestamp));
        }
        this.messages = Collections.unmodifiableList(messages);
    }

    public EResult getResult() {
        return this.result;
    }

    public SteamID getSteamID() {
        return this.steamID;
    }

    public List<FriendMessage> getMessages() {
        return this.messages;
    }
}

