/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamnotifications;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.handlers.steamnotifications.callback.CommentNotificationsCallback;
import in.dragonbra.javasteam.steam.handlers.steamnotifications.callback.ItemAnnouncementsCallback;
import in.dragonbra.javasteam.steam.handlers.steamnotifications.callback.OfflineMessageNotificationCallback;
import in.dragonbra.javasteam.steam.handlers.steamnotifications.callback.UserNotificationsCallback;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamNotifications
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamNotifications() {
        this.dispatchMap.put(EMsg.ClientUserNotifications, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamNotifications.this.handleUserNotifications(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientChatOfflineMessageNotification, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamNotifications.this.handleOfflineMessageNotification(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientCommentNotifications, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamNotifications.this.handleCommentNotifications(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientItemAnnouncements, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamNotifications.this.handleItemAnnouncements(packetMsg);
            }
        });
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public void requestCommentNotifications() {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestCommentNotifications.class, EMsg.ClientRequestCommentNotifications);
        this.client.send(request);
    }

    public void requestItemAnnouncements() {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestItemAnnouncements.class, EMsg.ClientRequestItemAnnouncements);
        this.client.send(request);
    }

    public void requestOfflineMessageCount() {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestOfflineMessageCount.class, EMsg.ClientChatRequestOfflineMessageCount);
        this.client.send(request);
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleUserNotifications(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUserNotifications.class, packetMsg);
        this.client.postCallback(new UserNotificationsCallback((SteammessagesClientserver2.CMsgClientUserNotifications.Builder)msg.getBody()));
    }

    private void handleOfflineMessageNotification(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientOfflineMessageNotification.class, packetMsg);
        this.client.postCallback(new OfflineMessageNotificationCallback((SteammessagesClientserver2.CMsgClientOfflineMessageNotification.Builder)msg.getBody()));
    }

    private void handleCommentNotifications(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientCommentNotifications.class, packetMsg);
        this.client.postCallback(new CommentNotificationsCallback((SteammessagesClientserver2.CMsgClientCommentNotifications.Builder)msg.getBody()));
    }

    private void handleItemAnnouncements(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientItemAnnouncements.class, packetMsg);
        this.client.postCallback(new ItemAnnouncementsCallback((SteammessagesClientserver2.CMsgClientItemAnnouncements.Builder)msg.getBody()));
    }
}

