/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamscreenshots;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.handlers.steamscreenshots.ScreenshotDetails;
import in.dragonbra.javasteam.steam.handlers.steamscreenshots.callback.ScreenshotAddedCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamScreenshots
extends ClientMsgHandler {
    public static final int SCREENSHOT_THUMBNAIL_WIDTH = 200;
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamScreenshots() {
        this.dispatchMap.put(EMsg.ClientUCMAddScreenshotResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamScreenshots.this.handleUCMAddScreenshot(packetMsg);
            }
        });
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID addScreenshot(ScreenshotDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUCMAddScreenshot.class, EMsg.ClientUCMAddScreenshot);
        JobID jobID = this.client.getNextJobID();
        msg.setSourceJobID(jobID);
        if (details.getGameID() != null) {
            ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setAppid(details.getGameID().getAppID());
        }
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setCaption(details.getCaption());
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setFilename(details.getUfsImageFilePath());
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setPermissions(details.getPrivacy().code());
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setThumbname(details.getUsfThumbnailFilePath());
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setWidth(details.getWidth());
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setHeight(details.getHeight());
        ((SteammessagesClientserver2.CMsgClientUCMAddScreenshot.Builder)msg.getBody()).setRtime32Created((int)(details.getCreationTime().getTime() / 1000L));
        this.client.send(msg);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleUCMAddScreenshot(IPacketMsg packetMsg) {
        ClientMsgProtobuf resp = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUCMAddScreenshotResponse.class, packetMsg);
        this.client.postCallback(new ScreenshotAddedCallback(resp.getTargetJobID(), (SteammessagesClientserver2.CMsgClientUCMAddScreenshotResponse.Builder)resp.getBody()));
    }
}

