/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamtrading;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.handlers.steamtrading.callback.SessionStartCallback;
import in.dragonbra.javasteam.steam.handlers.steamtrading.callback.TradeProposedCallback;
import in.dragonbra.javasteam.steam.handlers.steamtrading.callback.TradeResultCallback;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamTrading
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamTrading() {
        this.dispatchMap.put(EMsg.EconTrading_InitiateTradeProposed, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamTrading.this.handleTradeProposed(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.EconTrading_InitiateTradeResult, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamTrading.this.handleTradeResult(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.EconTrading_StartSession, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamTrading.this.handleStartSession(packetMsg);
            }
        });
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public void trade(SteamID user) {
        if (user == null) {
            throw new IllegalArgumentException("user is null");
        }
        ClientMsgProtobuf tradeReq = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgTrading_InitiateTradeRequest.class, EMsg.EconTrading_InitiateTradeRequest);
        ((SteammessagesClientserver2.CMsgTrading_InitiateTradeRequest.Builder)tradeReq.getBody()).setOtherSteamid(user.convertToUInt64());
        this.client.send(tradeReq);
    }

    public void respondToTrade(int tradeId, boolean acceptTrade) {
        ClientMsgProtobuf tradeResp = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgTrading_InitiateTradeResponse.class, EMsg.EconTrading_InitiateTradeResponse);
        ((SteammessagesClientserver2.CMsgTrading_InitiateTradeResponse.Builder)tradeResp.getBody()).setTradeRequestId(tradeId);
        ((SteammessagesClientserver2.CMsgTrading_InitiateTradeResponse.Builder)tradeResp.getBody()).setResponse(acceptTrade ? 1 : 0);
        this.client.send(tradeResp);
    }

    public void cancelTrade(SteamID user) {
        if (user == null) {
            throw new IllegalArgumentException("user is null");
        }
        ClientMsgProtobuf cancelTrade = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgTrading_CancelTradeRequest.class, EMsg.EconTrading_CancelTradeRequest);
        ((SteammessagesClientserver2.CMsgTrading_CancelTradeRequest.Builder)cancelTrade.getBody()).setOtherSteamid(user.convertToUInt64());
        this.client.send(cancelTrade);
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleTradeProposed(IPacketMsg packetMsg) {
        ClientMsgProtobuf tradeProp = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgTrading_InitiateTradeRequest.class, packetMsg);
        this.client.postCallback(new TradeProposedCallback((SteammessagesClientserver2.CMsgTrading_InitiateTradeRequest.Builder)tradeProp.getBody()));
    }

    private void handleTradeResult(IPacketMsg packetMsg) {
        ClientMsgProtobuf tradeResult = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgTrading_InitiateTradeResponse.class, packetMsg);
        this.client.postCallback(new TradeResultCallback((SteammessagesClientserver2.CMsgTrading_InitiateTradeResponse.Builder)tradeResult.getBody()));
    }

    private void handleStartSession(IPacketMsg packetMsg) {
        ClientMsgProtobuf startSess = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgTrading_StartSession.class, packetMsg);
        this.client.postCallback(new SessionStartCallback((SteammessagesClientserver2.CMsgTrading_StartSession.Builder)startSess.getBody()));
    }
}

