/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuser;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EAccountType;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.generated.MsgClientLogOnResponse;
import in.dragonbra.javasteam.generated.MsgClientLoggedOff;
import in.dragonbra.javasteam.generated.MsgClientMarketingMessageUpdate2;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.steam.handlers.steamuser.AnonymousLogOnDetails;
import in.dragonbra.javasteam.steam.handlers.steamuser.LogOnDetails;
import in.dragonbra.javasteam.steam.handlers.steamuser.MachineAuthDetails;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.AccountInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.EmailAddrInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoggedOffCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoggedOnCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoginKeyCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.MarketingMessageCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.SessionTokenCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.UpdateMachineAuthCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.VanityURLChangedCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.WalletInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.WebAPIUserNonceCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.HardwareUtils;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamUser
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamUser() {
        this.dispatchMap.put(EMsg.ClientLogOnResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleLogOnResponse(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientLoggedOff, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleLoggedOff(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientNewLoginKey, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleLoginKey(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientSessionToken, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleSessionToken(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientUpdateMachineAuth, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleUpdateMachineAuth(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientAccountInfo, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleAccountInfo(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientEmailAddrInfo, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleEmailAddrInfo(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientWalletInfoUpdate, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleWalletInfo(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientRequestWebAPIAuthenticateUserNonceResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleWebAPIUserNonce(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientVanityURLChangedNotification, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleVanityURLChangedNotification(packetMsg);
            }
        });
        this.dispatchMap.put(EMsg.ClientMarketingMessageUpdate2, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamUser.this.handleMarketingMessageUpdate(packetMsg);
            }
        });
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public void logOn(LogOnDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        if (Strings.isNullOrEmpty(details.getUsername()) || Strings.isNullOrEmpty(details.getPassword()) && Strings.isNullOrEmpty(details.getLoginKey())) {
            throw new IllegalArgumentException("LogOn requires a username and password to be set in 'details'.");
        }
        if (!Strings.isNullOrEmpty(details.getLoginKey()) && !details.isShouldRememberPassword()) {
            throw new IllegalArgumentException("ShouldRememberPassword is required to be set to true in order to use LoginKey.");
        }
        if (!this.client.isConnected()) {
            this.client.postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogon);
        SteamID steamID = new SteamID(details.getAccountID(), details.getAccountInstance(), this.client.getUniverse(), EAccountType.Individual);
        if (details.getLoginID() != null) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(details.getLoginID());
        } else {
            int localIp = NetHelpers.getIPAddress(this.client.getLocalIP());
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(localIp ^ 0xBAADF00D);
        }
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(steamID.convertToUInt64());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setAccountName(details.getUsername());
        if (!Strings.isNullOrEmpty(details.getPassword())) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setPassword(details.getPassword());
        }
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setShouldRememberPassword(details.isShouldRememberPassword());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65580);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(details.getClientOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientLanguage(details.getClientLanguage());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setCellId(details.getCellID());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setSteam2TicketRequest(details.isRequestSteam2Ticket());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientPackageVersion(1771);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setSupportsRateLimitResponse(true);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        if (!Strings.isNullOrEmpty(details.getAuthCode())) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setAuthCode(details.getAuthCode());
        }
        if (!Strings.isNullOrEmpty(details.getTwoFactorCode())) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setTwoFactorCode(details.getTwoFactorCode());
        }
        if (!Strings.isNullOrEmpty(details.getLoginKey())) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setLoginKey(details.getLoginKey());
        }
        if (details.getSentryFileHash() != null) {
            ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setShaSentryfile(ByteString.copyFrom((byte[])details.getSentryFileHash()));
        }
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setEresultSentryfile(details.getSentryFileHash() != null ? EResult.OK.code() : EResult.FileNotFound.code());
        this.client.send(logon);
    }

    public void logOnAnonymous() {
        this.logOnAnonymous(new AnonymousLogOnDetails());
    }

    public void logOnAnonymous(AnonymousLogOnDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        if (!this.client.isConnected()) {
            this.client.postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogon);
        SteamID auId = new SteamID(0L, 0L, this.client.getUniverse(), EAccountType.AnonUser);
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(auId.convertToUInt64());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65580);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(details.getClientOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientLanguage(details.getClientLanguage());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setCellId(details.getCellID());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        this.client.send(logon);
    }

    public void logOff() {
        this.setExpectDisconnection(true);
        ClientMsgProtobuf logOff = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogOff.class, EMsg.ClientLogOff);
        this.client.send(logOff);
        this.client.disconnect();
    }

    public void sendMachineAuthResponse(MachineAuthDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.class, EMsg.ClientUpdateMachineAuthResponse);
        response.getProtoHeader().setJobidTarget(details.getJobID().getValue());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setCubwrote(details.getBytesWritten());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setEresult(details.geteResult().code());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setFilename(details.getFileName());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setFilesize(details.getFileSize());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setGetlasterror(details.getLastError());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setOffset(details.getOffset());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setShaFile(ByteString.copyFrom((byte[])details.getSentryFileHash()));
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setOtpIdentifier(details.getOneTimePassword().getIdentifier());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setOtpType(details.getOneTimePassword().getType());
        ((SteammessagesClientserver2.CMsgClientUpdateMachineAuthResponse.Builder)response.getBody()).setOtpValue(details.getOneTimePassword().getValue());
        this.client.send(response);
    }

    public JobID requestWebAPIUserNonce() {
        ClientMsgProtobuf reqMsg = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientRequestWebAPIAuthenticateUserNonce.class, EMsg.ClientRequestWebAPIAuthenticateUserNonce);
        JobID jobID = this.client.getNextJobID();
        reqMsg.setSourceJobID(jobID);
        this.client.send(reqMsg);
        return jobID;
    }

    public void acceptNewLoginKey(LoginKeyCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        ClientMsgProtobuf acceptance = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientNewLoginKeyAccepted.class, EMsg.ClientNewLoginKeyAccepted);
        ((SteammessagesClientserverLogin.CMsgClientNewLoginKeyAccepted.Builder)acceptance.getBody()).setUniqueId(callback.getUniqueID());
        this.client.send(acceptance);
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    public SteamID getSteamID() {
        return this.client.getSteamID();
    }

    private void handleLogOnResponse(IPacketMsg packetMsg) {
        if (packetMsg.isProto()) {
            ClientMsgProtobuf logonResp = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogonResponse.class, packetMsg);
            this.client.postCallback(new LoggedOnCallback((SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder)logonResp.getBody()));
        } else {
            ClientMsg<MsgClientLogOnResponse> logonResp = new ClientMsg<MsgClientLogOnResponse>(MsgClientLogOnResponse.class, packetMsg);
            this.client.postCallback(new LoggedOnCallback(logonResp.getBody()));
        }
    }

    private void handleLoggedOff(IPacketMsg packetMsg) {
        EResult result;
        if (packetMsg.isProto()) {
            ClientMsgProtobuf loggedOff = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLoggedOff.class, packetMsg);
            result = EResult.from(((SteammessagesClientserverLogin.CMsgClientLoggedOff.Builder)loggedOff.getBody()).getEresult());
        } else {
            ClientMsg<MsgClientLoggedOff> loggedOff = new ClientMsg<MsgClientLoggedOff>(MsgClientLoggedOff.class, packetMsg);
            result = loggedOff.getBody().getResult();
        }
        this.client.postCallback(new LoggedOffCallback(result));
        this.client.disconnect();
    }

    private void handleLoginKey(IPacketMsg packetMsg) {
        ClientMsgProtobuf loginKey = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientNewLoginKey.class, packetMsg);
        this.client.postCallback(new LoginKeyCallback((SteammessagesClientserverLogin.CMsgClientNewLoginKey.Builder)loginKey.getBody()));
    }

    private void handleSessionToken(IPacketMsg packetMsg) {
        ClientMsgProtobuf sessToken = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientSessionToken.class, packetMsg);
        this.client.postCallback(new SessionTokenCallback((SteammessagesClientserver.CMsgClientSessionToken.Builder)sessToken.getBody()));
    }

    private void handleUpdateMachineAuth(IPacketMsg packetMsg) {
        ClientMsgProtobuf machineAuth = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUpdateMachineAuth.class, packetMsg);
        this.client.postCallback(new UpdateMachineAuthCallback(new JobID(packetMsg.getSourceJobID()), (SteammessagesClientserver2.CMsgClientUpdateMachineAuth.Builder)machineAuth.getBody()));
    }

    private void handleAccountInfo(IPacketMsg packetMsg) {
        ClientMsgProtobuf accInfo = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientAccountInfo.class, packetMsg);
        this.client.postCallback(new AccountInfoCallback((SteammessagesClientserverLogin.CMsgClientAccountInfo.Builder)accInfo.getBody()));
    }

    private void handleEmailAddrInfo(IPacketMsg packetMsg) {
        ClientMsgProtobuf emailAddrInfo = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientEmailAddrInfo.class, packetMsg);
        this.client.postCallback(new EmailAddrInfoCallback((SteammessagesClientserver2.CMsgClientEmailAddrInfo.Builder)emailAddrInfo.getBody()));
    }

    private void handleWalletInfo(IPacketMsg packetMsg) {
        ClientMsgProtobuf walletInfo = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientWalletInfoUpdate.class, packetMsg);
        this.client.postCallback(new WalletInfoCallback((SteammessagesClientserver.CMsgClientWalletInfoUpdate.Builder)walletInfo.getBody()));
    }

    private void handleWebAPIUserNonce(IPacketMsg packetMsg) {
        ClientMsgProtobuf userNonce = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientRequestWebAPIAuthenticateUserNonceResponse.class, packetMsg);
        this.client.postCallback(new WebAPIUserNonceCallback(userNonce.getTargetJobID(), (SteammessagesClientserverLogin.CMsgClientRequestWebAPIAuthenticateUserNonceResponse.Builder)userNonce.getBody()));
    }

    private void handleVanityURLChangedNotification(IPacketMsg packetMsg) {
        ClientMsgProtobuf vanityUrl = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientVanityURLChangedNotification.class, packetMsg);
        this.client.postCallback(new VanityURLChangedCallback(vanityUrl.getTargetJobID(), (SteammessagesClientserver2.CMsgClientVanityURLChangedNotification.Builder)vanityUrl.getBody()));
    }

    private void handleMarketingMessageUpdate(IPacketMsg packetMsg) {
        ClientMsg<MsgClientMarketingMessageUpdate2> marketingMessage = new ClientMsg<MsgClientMarketingMessageUpdate2>(MsgClientMarketingMessageUpdate2.class, packetMsg);
        byte[] payload = marketingMessage.getPayload().toByteArray();
        this.client.postCallback(new MarketingMessageCallback(marketingMessage.getBody(), payload));
    }
}

