/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuserstats;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLbs;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.types.UGCHandle;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LeaderboardEntry {
    private SteamID steamID;
    private int globalRank;
    private int score;
    private UGCHandle ugcId;
    private List<Integer> details;

    public LeaderboardEntry(SteammessagesClientserverLbs.CMsgClientLBSGetLBEntriesResponse.Entry entry) {
        this.globalRank = entry.getGlobalRank();
        this.score = entry.getScore();
        this.steamID = new SteamID(entry.getSteamIdUser());
        this.ugcId = new UGCHandle(entry.getUgcId());
        this.details = new ArrayList<Integer>();
        MemoryStream ms = new MemoryStream(entry.getDetails().toByteArray());
        BinaryReader br = new BinaryReader(ms);
        try {
            while (ms.getLength() - ms.getPosition() > 4L) {
                this.details.add(br.readInt());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to read details", e);
        }
        this.details = Collections.unmodifiableList(this.details);
    }

    public SteamID getSteamID() {
        return this.steamID;
    }

    public int getGlobalRank() {
        return this.globalRank;
    }

    public int getScore() {
        return this.score;
    }

    public UGCHandle getUgcId() {
        return this.ugcId;
    }

    public List<Integer> getDetails() {
        return this.details;
    }
}

