/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamworkshop;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.handlers.steamworkshop.EnumerationUserDetails;
import in.dragonbra.javasteam.steam.handlers.steamworkshop.callback.UserActionPublishedFilesCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamWorkshop
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamWorkshop() {
        this.dispatchMap.put(EMsg.ClientUCMEnumeratePublishedFilesByUserActionResponse, new Consumer<IPacketMsg>(){

            @Override
            public void accept(IPacketMsg packetMsg) {
                SteamWorkshop.this.handleEnumPublishedFilesByAction(packetMsg);
            }
        });
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID enumeratePublishedFilesByUserAction(EnumerationUserDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        ClientMsgProtobuf enumRequest = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserAction.class, EMsg.ClientUCMEnumeratePublishedFilesByUserAction);
        JobID jobID = this.client.getNextJobID();
        enumRequest.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserAction.Builder)enumRequest.getBody()).setAction(details.getUserAction().code());
        ((SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserAction.Builder)enumRequest.getBody()).setAppId(details.getAppID());
        ((SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserAction.Builder)enumRequest.getBody()).setStartIndex(details.getStartIndex());
        this.client.send(enumRequest);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleEnumPublishedFilesByAction(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.class, packetMsg);
        this.client.postCallback(new UserActionPublishedFilesCallback(response.getTargetJobID(), (SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.Builder)response.getBody()));
    }
}

