/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamworkshop.callback;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class UserActionPublishedFilesCallback
extends CallbackMsg {
    private EResult result;
    private List<File> files;
    private int totalResults;

    public UserActionPublishedFilesCallback(JobID jobID, SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.Builder msg) {
        this.setJobID(jobID);
        this.result = EResult.from(msg.getEresult());
        ArrayList<File> fileList = new ArrayList<File>();
        for (SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.PublishedFileId f : msg.getPublishedFilesList()) {
            fileList.add(new File(f));
        }
        this.files = Collections.unmodifiableList(fileList);
        this.totalResults = msg.getTotalResults();
    }

    public EResult getResult() {
        return this.result;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public static class File {
        private long fileID;
        private Date timestamp;

        public File(SteammessagesClientserver2.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.PublishedFileId file) {
            this.fileID = file.getPublishedFileId();
            this.timestamp = new Date((long)file.getRtimeTimeStamp() * 1000L);
        }

        public long getFileID() {
            return this.fileID;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }
}

