/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient.callbackmgr;

import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackBase;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.ICallbackMgrInternals;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.ICallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.io.Closeable;

public class Callback<TCall extends ICallbackMsg>
extends CallbackBase
implements Closeable {
    ICallbackMgrInternals mgr;
    private JobID jobID;
    private Consumer<TCall> onRun;
    private Class<? extends TCall> callbackType;

    public Callback(Class<? extends TCall> callbackType, Consumer<TCall> func) {
        this(callbackType, func, null);
    }

    public Callback(Class<? extends TCall> callbackType, Consumer<TCall> func, ICallbackMgrInternals mgr) {
        this(callbackType, func, mgr, JobID.INVALID);
    }

    public Callback(Class<? extends TCall> callbackType, Consumer<TCall> func, ICallbackMgrInternals mgr, JobID jobID) {
        this.jobID = jobID;
        this.onRun = func;
        this.callbackType = callbackType;
        this.attachTo(mgr);
    }

    void attachTo(ICallbackMgrInternals mgr) {
        if (mgr == null) {
            return;
        }
        this.mgr = mgr;
        mgr.register(this);
    }

    @Override
    Class getCallbackType() {
        return this.callbackType;
    }

    @Override
    void run(Object callback) {
        ICallbackMsg cb;
        if (this.callbackType.isAssignableFrom(callback.getClass()) && ((cb = (ICallbackMsg)callback).getJobID().equals(this.jobID) || this.jobID.equals(JobID.INVALID)) && this.onRun != null) {
            this.onRun.accept(cb);
        }
    }

    @Override
    public void close() {
        if (this.mgr != null) {
            this.mgr.unregister(this);
        }
    }
}

