/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient.configuration;

import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.SmartCMServerList;
import in.dragonbra.javasteam.steam.steamclient.configuration.ISteamConfigurationBuilder;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfigurationBuilder;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfigurationState;
import in.dragonbra.javasteam.steam.webapi.WebAPI;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.EnumSet;
import okhttp3.OkHttpClient;

public class SteamConfiguration {
    private final SteamConfigurationState state;
    private SmartCMServerList serverList;

    SteamConfiguration(SteamConfigurationState state) {
        this.state = state;
        this.serverList = new SmartCMServerList(this);
    }

    public static SteamConfiguration create(Consumer<ISteamConfigurationBuilder> configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("configurator is null");
        }
        SteamConfigurationBuilder builder = new SteamConfigurationBuilder();
        configurator.accept(builder);
        return builder.build();
    }

    public static SteamConfiguration createDefault() {
        return new SteamConfiguration(SteamConfigurationBuilder.createDefaultState());
    }

    public boolean isAllowDirectoryFetch() {
        return this.state.isAllowDirectoryFetch();
    }

    public int getCellID() {
        return this.state.getCellID();
    }

    public long getConnectionTimeout() {
        return this.state.getConnectionTimeout();
    }

    public OkHttpClient getHttpClient() {
        return this.state.getHttpClient();
    }

    public EnumSet<EClientPersonaStateFlag> getDefaultPersonaStateFlags() {
        return this.state.getDefaultPersonaStateFlags();
    }

    public EnumSet<ProtocolTypes> getProtocolTypes() {
        return this.state.getProtocolTypes();
    }

    public IServerListProvider getServerListProvider() {
        return this.state.getServerListProvider();
    }

    public EUniverse getUniverse() {
        return this.state.getUniverse();
    }

    public String getWebAPIBaseAddress() {
        return this.state.getWebAPIBaseAddress();
    }

    public String getWebAPIKey() {
        return this.state.getWebAPIKey();
    }

    public SmartCMServerList getServerList() {
        return this.serverList;
    }

    public WebAPI getWebAPI(String _interface) {
        return new WebAPI(this.getHttpClient(), this.getWebAPIBaseAddress(), _interface, this.getWebAPIKey());
    }
}

