/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient.configuration;

import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.discovery.IServerListProvider;
import in.dragonbra.javasteam.steam.discovery.NullServerListProvider;
import in.dragonbra.javasteam.steam.steamclient.configuration.ISteamConfigurationBuilder;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfigurationState;
import java.util.EnumSet;
import okhttp3.OkHttpClient;

public class SteamConfigurationBuilder
implements ISteamConfigurationBuilder {
    private SteamConfigurationState state = SteamConfigurationBuilder.createDefaultState();

    public static SteamConfigurationState createDefaultState() {
        SteamConfigurationState state = new SteamConfigurationState();
        state.setAllowDirectoryFetch(true);
        state.setConnectionTimeout(5000L);
        state.setDefaultPersonaStateFlags(EnumSet.of(EClientPersonaStateFlag.PlayerName, EClientPersonaStateFlag.Presence, EClientPersonaStateFlag.SourceID, EClientPersonaStateFlag.GameExtraInfo, EClientPersonaStateFlag.LastSeen));
        state.setProtocolTypes(ProtocolTypes.TCP);
        state.setServerListProvider(new NullServerListProvider());
        state.setUniverse(EUniverse.Public);
        state.setWebAPIBaseAddress("https://api.steampowered.com/");
        state.setHttpClient(new OkHttpClient());
        return state;
    }

    public SteamConfiguration build() {
        return new SteamConfiguration(this.state);
    }

    @Override
    public ISteamConfigurationBuilder withCellID(int cellID) {
        this.state.setCellID(cellID);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withConnectionTimeout(long connectionTimeout) {
        this.state.setConnectionTimeout(connectionTimeout);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withHttpClient(OkHttpClient httpClient) {
        this.state.setHttpClient(httpClient);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withDefaultPersonaStateFlags(EnumSet<EClientPersonaStateFlag> personaStateFlags) {
        this.state.setDefaultPersonaStateFlags(personaStateFlags);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withDefaultPersonaStateFlags(EClientPersonaStateFlag personaStateFlags) {
        this.state.setDefaultPersonaStateFlags(personaStateFlags);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withDirectoryFetch(boolean allowDirectoryFetch) {
        this.state.setAllowDirectoryFetch(allowDirectoryFetch);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withProtocolTypes(EnumSet<ProtocolTypes> protocolTypes) {
        this.state.setProtocolTypes(protocolTypes);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withProtocolTypes(ProtocolTypes protocolTypes) {
        this.state.setProtocolTypes(protocolTypes);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withServerListProvider(IServerListProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        this.state.setServerListProvider(provider);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withUniverse(EUniverse universe) {
        this.state.setUniverse(universe);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withWebAPIBaseAddress(String baseAddress) {
        if (baseAddress == null) {
            throw new IllegalArgumentException("baseAddress is null");
        }
        this.state.setWebAPIBaseAddress(baseAddress);
        return this;
    }

    @Override
    public ISteamConfigurationBuilder withWebAPIKey(String webApiKey) {
        if (webApiKey == null) {
            throw new IllegalArgumentException("webApiKey is null");
        }
        this.state.setWebAPIKey(webApiKey);
        return this;
    }
}

