/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.types.BitVector64;
import in.dragonbra.javasteam.util.compat.ObjectsCompat;
import java.util.Date;

public class GlobalID {
    private BitVector64 gidBits;

    public GlobalID() {
        this(-1L);
    }

    public GlobalID(long gid) {
        this.gidBits = new BitVector64(gid);
    }

    public void setSequentialCount(long value) {
        this.gidBits.setMask((short)0, 1048575L, value);
    }

    public long getSequentialCount() {
        return this.gidBits.getMask((short)0, 1048575L);
    }

    public void setStartTime(Date startTime) {
        long startTimeS = (startTime.getTime() - 1104537600000L) / 1000L;
        this.gidBits.setMask((short)20, 0x3FFFFFFFL, startTimeS);
    }

    public Date getStartTime() {
        long startTimeS = this.gidBits.getMask((short)20, 0x3FFFFFFFL);
        return new Date(startTimeS * 1000L);
    }

    public void setProcessID(long value) {
        this.gidBits.setMask((short)50, 15L, value);
    }

    public long getProcessID() {
        return this.gidBits.getMask((short)50, 15L);
    }

    public void setBoxID(long value) {
        this.gidBits.setMask((short)54, 1023L, value);
    }

    public long getBoxID() {
        return this.gidBits.getMask((short)54, 1023L);
    }

    public void setValue(long value) {
        this.gidBits.setData(value);
    }

    public long getValue() {
        return this.gidBits.getData();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalID)) {
            return false;
        }
        return ObjectsCompat.equals(this.gidBits.getData(), ((GlobalID)obj).gidBits.getData());
    }

    public int hashCode() {
        return this.gidBits.getData().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

