/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Scanner;
import org.apache.commons.lang3.SystemUtils;

public class HardwareUtils {
    private static String SERIAL_NUMBER;

    public static byte[] getMachineID() {
        if (SERIAL_NUMBER != null) {
            return SERIAL_NUMBER.getBytes();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            SERIAL_NUMBER = HardwareUtils.getSerialNumberWin();
        }
        if (SystemUtils.IS_OS_MAC) {
            SERIAL_NUMBER = HardwareUtils.getSerialNumberMac();
        }
        if (SystemUtils.IS_OS_LINUX) {
            SERIAL_NUMBER = HardwareUtils.getSerialNumberUnix();
        }
        return SERIAL_NUMBER == null ? new byte[]{} : SERIAL_NUMBER.getBytes();
    }

    private static String getSerialNumberWin() {
        Process process;
        String sn = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(new String[]{"wmic", "bios", "get", "serialnumber"});
        }
        catch (IOException e) {
            return null;
        }
        OutputStream os = process.getOutputStream();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (Scanner sc = new Scanner(process.getInputStream());){
            while (sc.hasNext()) {
                String next = sc.next();
                if (!"SerialNumber".equals(next)) continue;
                sn = sc.next().trim();
                break;
            }
        }
        return sn;
    }

    private static String getSerialNumberMac() {
        Process process;
        String sn = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(new String[]{"/usr/sbin/system_profiler", "SPHardwareDataType"});
        }
        catch (IOException e) {
            return null;
        }
        OutputStream os = process.getOutputStream();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String marker = "Serial Number";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains(marker)) continue;
                sn = line.split(":")[1].trim();
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
        return sn;
    }

    private static String getSerialNumberUnix() {
        String sn = HardwareUtils.readDmidecode();
        if (sn == null) {
            sn = HardwareUtils.readLshal();
        }
        return sn;
    }

    private static BufferedReader read(String command) {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(command.split(" "));
        }
        catch (IOException e) {
            return null;
        }
        OutputStream os = process.getOutputStream();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readDmidecode() {
        String sn = null;
        String marker = "Serial Number:";
        try (BufferedReader br = HardwareUtils.read("dmidecode -t system");){
            String line;
            if (br == null) {
                String string = null;
                return string;
            }
            do {
                if ((line = br.readLine()) == null) return sn;
            } while (!line.contains(marker));
            sn = line.split(marker)[1].trim();
            return sn;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readLshal() {
        String sn = null;
        String marker = "system.hardware.serial =";
        try (BufferedReader br = HardwareUtils.read("lshal");){
            String line;
            if (br == null) {
                String string = null;
                return string;
            }
            do {
                if ((line = br.readLine()) == null) return sn;
            } while (!line.contains(marker));
            sn = line.split(marker)[1].replaceAll("\\(string\\)|(\\')", "").trim();
            return sn;
        }
        catch (IOException e) {
            return null;
        }
    }
}

