/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.util.IDebugNetworkListener;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class NetHookNetworkListener
implements IDebugNetworkListener {
    private static final Logger logger = LogManager.getLogger(NetHookNetworkListener.class);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy_MM_dd_H_m_s_S");
    private AtomicLong messageNumber = new AtomicLong(0L);
    private File logDirectory;

    public NetHookNetworkListener() {
        this("netlogs");
    }

    public NetHookNetworkListener(String path) {
        File dir = new File(path);
        dir.mkdir();
        this.logDirectory = new File(dir, FORMAT.format(new Date()));
        this.logDirectory.mkdir();
    }

    @Override
    public void onIncomingNetworkMessage(EMsg msgType, byte[] data) {
        try {
            Files.write(Paths.get(new File(this.logDirectory, this.getFile("in", msgType)).getAbsolutePath(), new String[0]), data, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.debug(e);
        }
    }

    @Override
    public void onOutgoingNetworkMessage(EMsg msgType, byte[] data) {
        try {
            Files.write(Paths.get(new File(this.logDirectory, this.getFile("out", msgType)).getAbsolutePath(), new String[0]), data, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.debug(e);
        }
    }

    private String getFile(String direction, EMsg msgType) {
        return String.format("%d_%s_%d_k_EMsg%s.bin", this.messageNumber.getAndIncrement(), direction, msgType.code(), msgType.toString());
    }
}

