/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import java.nio.charset.Charset;

public class WebHelpers {
    private static boolean isUrlSafeChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.' || ch == '_';
    }

    public static String urlEncode(String input) {
        return WebHelpers.urlEncode(input.getBytes(Charset.forName("UTF-8")));
    }

    public static String urlEncode(byte[] input) {
        StringBuilder encoded = new StringBuilder(input.length * 2);
        for (byte i : input) {
            char inch = (char)i;
            if (WebHelpers.isUrlSafeChar(inch)) {
                encoded.append(inch);
                continue;
            }
            if (inch == ' ') {
                encoded.append('+');
                continue;
            }
            encoded.append(String.format("%%%02X", i));
        }
        return encoded.toString();
    }
}

