/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.crypto;

import in.dragonbra.javasteam.util.crypto.AsnKeyParser;
import in.dragonbra.javasteam.util.crypto.BerDecodeException;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSACrypto {
    private static final Logger logger = LogManager.getLogger(RSACrypto.class);
    private Cipher cipher;

    public RSACrypto(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            ArrayList<Byte> list = new ArrayList<Byte>();
            for (byte b : key) {
                list.add(b);
            }
            AsnKeyParser keyParser = new AsnKeyParser(list);
            BigInteger[] keys = keyParser.parseRSAPublicKey();
            this.init(keys[0], keys[1]);
        }
        catch (BerDecodeException e) {
            e.printStackTrace();
        }
    }

    private void init(BigInteger mod, BigInteger exp) {
        try {
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(mod, exp);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPublicKey rsaKey = (RSAPublicKey)factory.generatePublic(publicKeySpec);
            this.cipher = Cipher.getInstance("RSA/None/OAEPWithSHA1AndMGF1Padding", CryptoHelper.SEC_PROV);
            this.cipher.init(1, rsaKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | NoSuchPaddingException e) {
            logger.debug(e);
        }
    }

    public byte[] encrypt(byte[] input) {
        try {
            return this.cipher.doFinal(input);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            logger.debug(e);
            return null;
        }
    }
}

