/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class AbstractMsgBase {
    protected MemoryStream payload;
    private final BinaryReader reader;
    private final BinaryWriter writer;

    public AbstractMsgBase() {
        this(0);
    }

    public AbstractMsgBase(int payloadReserve) {
        this.payload = new MemoryStream(payloadReserve);
        this.reader = new BinaryReader(this.payload);
        this.writer = new BinaryWriter(this.payload.asOutputStream());
    }

    public long seek(long offset, SeekOrigin seekOrigin) {
        return this.payload.seek(offset, seekOrigin);
    }

    public void write(byte data) throws IOException {
        this.writer.write(data);
    }

    public void write(short data) throws IOException {
        this.writer.writeShort(data);
    }

    public void write(int data) throws IOException {
        this.writer.writeInt(data);
    }

    public void write(long data) throws IOException {
        this.writer.writeLong(data);
    }

    public void write(byte[] data) throws IOException {
        this.writer.write(data);
    }

    public void write(float data) throws IOException {
        this.writer.writeFloat(data);
    }

    public void write(double data) throws IOException {
        this.writer.writeDouble(data);
    }

    public void write(String data) throws IOException {
        this.write(data, Charset.defaultCharset());
    }

    public void write(String data, Charset charset) throws IOException {
        if (data == null) {
            return;
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.write(data.getBytes(charset));
    }

    public void writeNullTermString(String data) throws IOException {
        this.writeNullTermString(data, Charset.defaultCharset());
    }

    public void writeNullTermString(String data, Charset charset) throws IOException {
        this.write(data, charset);
        this.write("\u0000", charset);
    }

    public byte readByte() throws IOException {
        return this.reader.readByte();
    }

    public byte[] readBytes(int numBytes) throws IOException {
        return this.reader.readBytes(numBytes);
    }

    public short readShort() throws IOException {
        return this.reader.readShort();
    }

    public int readInt() throws IOException {
        return this.reader.readInt();
    }

    public long readLong() throws IOException {
        return this.reader.readLong();
    }

    public float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    public double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    public String readNullTermString() throws IOException {
        return this.readNullTermString(Charset.defaultCharset());
    }

    public String readNullTermString(Charset charset) throws IOException {
        return this.reader.readNullTermString(charset);
    }

    public MemoryStream getPayload() {
        return this.payload;
    }
}

