/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.ISteamSerializableMessage;
import in.dragonbra.javasteam.base.MsgBase;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.ExtendedClientMsgHdr;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ClientMsg<BodyType extends ISteamSerializableMessage>
extends MsgBase<ExtendedClientMsgHdr> {
    private static final Logger logger = LogManager.getLogger(ClientMsg.class);
    private BodyType body;

    public ClientMsg(Class<? extends BodyType> bodyType) {
        this(bodyType, 64);
    }

    public ClientMsg(Class<? extends BodyType> bodyType, int payloadReserve) {
        super(ExtendedClientMsgHdr.class, payloadReserve);
        try {
            this.body = (ISteamSerializableMessage)bodyType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.debug(e);
        }
        ((ExtendedClientMsgHdr)this.getHeader()).setEMsg(this.body.getEMsg());
    }

    public ClientMsg(Class<? extends BodyType> bodyType, MsgBase<ExtendedClientMsgHdr> msg) {
        this(bodyType, msg, 64);
    }

    public ClientMsg(Class<? extends BodyType> bodyType, MsgBase<ExtendedClientMsgHdr> msg, int payloadReserve) {
        this((Class<BodyType>)bodyType, payloadReserve);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        ((ExtendedClientMsgHdr)this.getHeader()).setTargetJobID(msg.getHeader().getSourceJobID());
    }

    public ClientMsg(Class<? extends BodyType> bodyType, IPacketMsg msg) {
        this(bodyType);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        if (msg.isProto()) {
            logger.debug("ClientMsg<" + bodyType.getName() + "> used for proto message!");
        }
        this.deserialize(msg.getData());
    }

    @Override
    public boolean isProto() {
        return false;
    }

    @Override
    public EMsg getMsgType() {
        return ((ExtendedClientMsgHdr)this.getHeader()).getMsg();
    }

    @Override
    public int getSessionID() {
        return ((ExtendedClientMsgHdr)this.getHeader()).getSessionID();
    }

    @Override
    public void setSessionID(int sessionID) {
        ((ExtendedClientMsgHdr)this.getHeader()).setSessionID(sessionID);
    }

    @Override
    public SteamID getSteamID() {
        return ((ExtendedClientMsgHdr)this.getHeader()).getSteamID();
    }

    @Override
    public void setSteamID(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ((ExtendedClientMsgHdr)this.getHeader()).setSteamID(steamID);
    }

    @Override
    public JobID getTargetJobID() {
        return new JobID(((ExtendedClientMsgHdr)this.getHeader()).getTargetJobID());
    }

    @Override
    public void setTargetJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        ((ExtendedClientMsgHdr)this.getHeader()).setTargetJobID(jobID.getValue());
    }

    @Override
    public JobID getSourceJobID() {
        return new JobID(((ExtendedClientMsgHdr)this.getHeader()).getSourceJobID());
    }

    @Override
    public void setSourceJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        ((ExtendedClientMsgHdr)this.getHeader()).setSourceJobID(jobID.getValue());
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0);
        try {
            ((ExtendedClientMsgHdr)this.getHeader()).serialize(baos);
            this.body.serialize(baos);
            baos.write(this.payload.toByteArray());
        }
        catch (IOException e) {
            logger.debug(e);
        }
        return baos.toByteArray();
    }

    @Override
    public void deserialize(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        MemoryStream ms = new MemoryStream(data);
        try {
            ((ExtendedClientMsgHdr)this.getHeader()).deserialize(ms);
            this.body.deserialize(ms);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.payload.write(data, (int)ms.getPosition(), ms.available());
        this.payload.seek(0L, SeekOrigin.BEGIN);
    }

    public BodyType getBody() {
        return this.body;
    }
}

