/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.IPacketGCMsg;
import in.dragonbra.javasteam.generated.MsgGCHdrProtoBuf;
import in.dragonbra.javasteam.types.JobID;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PacketClientGCMsgProtobuf
implements IPacketGCMsg {
    private final int msgType;
    private final JobID targetJobID;
    private final JobID sourceJobID;
    private final byte[] payload;

    public PacketClientGCMsgProtobuf(int eMsg, byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        this.msgType = eMsg;
        this.payload = data;
        MsgGCHdrProtoBuf protobufHeader = new MsgGCHdrProtoBuf();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            protobufHeader.deserialize(bais);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.targetJobID = new JobID(protobufHeader.getProto().getJobidTarget());
        this.sourceJobID = new JobID(protobufHeader.getProto().getJobidSource());
    }

    @Override
    public boolean isProto() {
        return true;
    }

    @Override
    public int getMsgType() {
        return this.msgType;
    }

    @Override
    public JobID getTargetJobID() {
        return this.targetJobID;
    }

    @Override
    public JobID getSourceJobID() {
        return this.sourceJobID;
    }

    @Override
    public byte[] getData() {
        return this.payload;
    }
}

