/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps;

import in.dragonbra.javasteam.enums.ELicenseFlags;
import in.dragonbra.javasteam.enums.ELicenseType;
import in.dragonbra.javasteam.enums.EPaymentMethod;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import java.util.Date;
import java.util.EnumSet;

public class License {
    private final int packageID;
    private final int lastChangeNumber;
    private final Date timeCreated;
    private final Date timeNextProcess;
    private final int minuteLimit;
    private final int minutesUsed;
    private final EPaymentMethod paymentMethod;
    private final EnumSet<ELicenseFlags> licenseFlags;
    private final String purchaseCode;
    private final ELicenseType licenseType;
    private final int territoryCode;
    private final long accessToken;
    private final int ownerAccountID;
    private final int masterPackageID;

    public License(SteammessagesClientserver.CMsgClientLicenseList.License license) {
        this.packageID = license.getPackageId();
        this.lastChangeNumber = license.getChangeNumber();
        this.timeCreated = new Date((long)license.getTimeCreated() * 1000L);
        this.timeNextProcess = new Date((long)license.getTimeNextProcess() * 1000L);
        this.minuteLimit = license.getMinuteLimit();
        this.minutesUsed = license.getMinutesUsed();
        this.paymentMethod = EPaymentMethod.from(license.getPaymentMethod());
        this.licenseFlags = ELicenseFlags.from(license.getFlags());
        this.purchaseCode = license.getPurchaseCountryCode();
        this.licenseType = ELicenseType.from(license.getLicenseType());
        this.territoryCode = license.getTerritoryCode();
        this.accessToken = license.getAccessToken();
        this.ownerAccountID = license.getOwnerId();
        this.masterPackageID = license.getMasterPackageId();
    }

    public int getPackageID() {
        return this.packageID;
    }

    public int getLastChangeNumber() {
        return this.lastChangeNumber;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeNextProcess() {
        return this.timeNextProcess;
    }

    public int getMinuteLimit() {
        return this.minuteLimit;
    }

    public int getMinutesUsed() {
        return this.minutesUsed;
    }

    public EPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public EnumSet<ELicenseFlags> getLicenseFlags() {
        return this.licenseFlags;
    }

    public String getPurchaseCode() {
        return this.purchaseCode;
    }

    public ELicenseType getLicenseType() {
        return this.licenseType;
    }

    public int getTerritoryCode() {
        return this.territoryCode;
    }

    public long getAccessToken() {
        return this.accessToken;
    }

    public int getOwnerAccountID() {
        return this.ownerAccountID;
    }

    public int getMasterPackageID() {
        return this.masterPackageID;
    }
}

