/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps;

import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgClientGetLegacyGameKey;
import in.dragonbra.javasteam.generated.MsgClientGetLegacyGameKeyResponse;
import in.dragonbra.javasteam.generated.MsgClientUpdateGuestPassesList;
import in.dragonbra.javasteam.generated.MsgClientVACBanStatus;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverAppinfo;
import in.dragonbra.javasteam.steam.handlers.steamapps.PICSRequest;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.AppOwnershipTicketCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.CDNAuthTokenCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.CheckAppBetaPasswordCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.DepotKeyCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.FreeLicenseCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.GameConnectTokensCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.GuestPassListCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.LegacyGameKeyCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.LicenseListCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PICSChangesCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PICSProductInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PICSTokensCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.PurchaseResponseCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.RedeemGuestPassResponseCallback;
import in.dragonbra.javasteam.steam.handlers.steamapps.callback.VACStatusCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamApps
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamApps() {
        this.dispatchMap.put(EMsg.ClientLicenseList, this::handleLicenseList);
        this.dispatchMap.put(EMsg.ClientRequestFreeLicenseResponse, this::handleFreeLicense);
        this.dispatchMap.put(EMsg.ClientPurchaseResponse, this::handlePurchaseResponse);
        this.dispatchMap.put(EMsg.ClientRedeemGuestPassResponse, this::handleRedeemGuestPassResponse);
        this.dispatchMap.put(EMsg.ClientGameConnectTokens, this::handleGameConnectTokens);
        this.dispatchMap.put(EMsg.ClientVACBanStatus, this::handleVACBanStatus);
        this.dispatchMap.put(EMsg.ClientGetAppOwnershipTicketResponse, this::handleAppOwnershipTicketResponse);
        this.dispatchMap.put(EMsg.ClientGetDepotDecryptionKeyResponse, this::handleDepotKeyResponse);
        this.dispatchMap.put(EMsg.ClientGetLegacyGameKeyResponse, this::handleLegacyGameKeyResponse);
        this.dispatchMap.put(EMsg.ClientPICSAccessTokenResponse, this::handlePICSAccessTokenResponse);
        this.dispatchMap.put(EMsg.ClientPICSChangesSinceResponse, this::handlePICSChangesSinceResponse);
        this.dispatchMap.put(EMsg.ClientPICSProductInfoResponse, this::handlePICSProductInfoResponse);
        this.dispatchMap.put(EMsg.ClientUpdateGuestPassesList, this::handleGuestPassList);
        this.dispatchMap.put(EMsg.ClientGetCDNAuthTokenResponse, this::handleCDNAuthTokenResponse);
        this.dispatchMap.put(EMsg.ClientCheckAppBetaPasswordResponse, this::handleCheckAppBetaPasswordResponse);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID getAppOwnershipTicket(int appId) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientGetAppOwnershipTicket.class, EMsg.ClientGetAppOwnershipTicket);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver.CMsgClientGetAppOwnershipTicket.Builder)request.getBody()).setAppId(appId);
        this.client.send(request);
        return jobID;
    }

    public JobID getDepotDecryptionKey(int depotId, int appId) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetDepotDecryptionKey.class, EMsg.ClientGetDepotDecryptionKey);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientGetDepotDecryptionKey.Builder)request.getBody()).setDepotId(depotId);
        ((SteammessagesClientserver2.CMsgClientGetDepotDecryptionKey.Builder)request.getBody()).setAppId(appId);
        this.client.send(request);
        return jobID;
    }

    public JobID picsGetAccessTokens(Integer app, Integer _package) {
        ArrayList<Integer> apps = new ArrayList<Integer>();
        ArrayList<Integer> packages = new ArrayList<Integer>();
        if (app != null) {
            apps.add(app);
        }
        if (_package != null) {
            packages.add(_package);
        }
        return this.picsGetAccessTokens(apps, packages);
    }

    public JobID picsGetAccessTokens(Iterable<Integer> appIds, Iterable<Integer> packageIds) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenRequest.class, EMsg.ClientPICSAccessTokenRequest);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenRequest.Builder)request.getBody()).addAllAppids(appIds);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenRequest.Builder)request.getBody()).addAllPackageids(packageIds);
        this.client.send(request);
        return jobID;
    }

    public JobID picsGetChangesSince() {
        return this.picsGetChangesSince(0, true, false);
    }

    public JobID picsGetChangesSince(int lastChangeNumber) {
        return this.picsGetChangesSince(lastChangeNumber, true, false);
    }

    public JobID picsGetChangesSince(int lastChangeNumber, boolean sendAppChangeList) {
        return this.picsGetChangesSince(lastChangeNumber, sendAppChangeList, false);
    }

    public JobID picsGetChangesSince(int lastChangeNumber, boolean sendAppChangeList, boolean sendPackageChangelist) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.class, EMsg.ClientPICSChangesSinceRequest);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.Builder)request.getBody()).setSinceChangeNumber(lastChangeNumber);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.Builder)request.getBody()).setSendAppInfoChanges(sendAppChangeList);
        ((SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceRequest.Builder)request.getBody()).setSendPackageInfoChanges(sendPackageChangelist);
        this.client.send(request);
        return jobID;
    }

    public JobID picsGetProductInfo(PICSRequest app, PICSRequest _package) {
        return this.picsGetProductInfo(app, _package, false);
    }

    public JobID picsGetProductInfo(PICSRequest app, PICSRequest _package, boolean metaDataOnly) {
        ArrayList<PICSRequest> apps = new ArrayList<PICSRequest>();
        ArrayList<PICSRequest> packages = new ArrayList<PICSRequest>();
        if (app != null) {
            apps.add(app);
        }
        if (_package != null) {
            packages.add(_package);
        }
        return this.picsGetProductInfo(apps, packages, metaDataOnly);
    }

    public JobID picsGetProductInfo(Iterable<PICSRequest> apps, Iterable<PICSRequest> packages) {
        return this.picsGetProductInfo(apps, packages, false);
    }

    public JobID picsGetProductInfo(Iterable<PICSRequest> apps, Iterable<PICSRequest> packages, boolean metaDataOnly) {
        if (apps == null) {
            throw new IllegalArgumentException("apps is null");
        }
        if (packages == null) {
            throw new IllegalArgumentException("packages is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.class, EMsg.ClientPICSProductInfoRequest);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        for (PICSRequest appRequest : apps) {
            SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.AppInfo.Builder appInfo = SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.AppInfo.newBuilder();
            appInfo.setAccessToken(appRequest.getAccessToken());
            appInfo.setAppid(appRequest.getId());
            appInfo.setOnlyPublicObsolete(false);
            ((SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.Builder)request.getBody()).addApps(appInfo);
        }
        for (PICSRequest packageRequest : packages) {
            SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.PackageInfo.Builder packageInfo = SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.PackageInfo.newBuilder();
            packageInfo.setAccessToken(packageRequest.getAccessToken());
            packageInfo.setPackageid(packageRequest.getId());
            ((SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.Builder)request.getBody()).addPackages(packageInfo);
        }
        ((SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoRequest.Builder)request.getBody()).setMetaDataOnly(metaDataOnly);
        this.client.send(request);
        return jobID;
    }

    public JobID getCDNAuthToken(int app, int depot, String hostName) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetCDNAuthToken.class, EMsg.ClientGetCDNAuthToken);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientGetCDNAuthToken.Builder)request.getBody()).setAppId(app);
        ((SteammessagesClientserver2.CMsgClientGetCDNAuthToken.Builder)request.getBody()).setDepotId(depot);
        ((SteammessagesClientserver2.CMsgClientGetCDNAuthToken.Builder)request.getBody()).setHostName(hostName);
        this.client.send(request);
        return jobID;
    }

    public JobID requestFreeLicense(int app) {
        ArrayList<Integer> apps = new ArrayList<Integer>();
        apps.add(app);
        return this.requestFreeLicense(apps);
    }

    public JobID requestFreeLicense(Iterable<Integer> apps) {
        if (apps == null) {
            throw new IllegalArgumentException("apps is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestFreeLicense.class, EMsg.ClientRequestFreeLicense);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientRequestFreeLicense.Builder)request.getBody()).addAllAppids(apps);
        this.client.send(request);
        return jobID;
    }

    public JobID checkAppBetaPassword(int app, String password) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientCheckAppBetaPassword.class, EMsg.ClientCheckAppBetaPassword);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgClientCheckAppBetaPassword.Builder)request.getBody()).setAppId(app);
        ((SteammessagesClientserver2.CMsgClientCheckAppBetaPassword.Builder)request.getBody()).setBetapassword(password);
        this.client.send(request);
        return jobID;
    }

    public JobID getLegacyGameKey(int appId) {
        ClientMsg<MsgClientGetLegacyGameKey> request = new ClientMsg<MsgClientGetLegacyGameKey>(MsgClientGetLegacyGameKey.class);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        request.setSourceJobID(jobID);
        request.getBody().setAppId(appId);
        this.client.send(request);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleAppOwnershipTicketResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf ticketResponse = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientGetAppOwnershipTicketResponse.class, packetMsg);
        this.client.postCallback(new AppOwnershipTicketCallback(ticketResponse.getTargetJobID(), (SteammessagesClientserver.CMsgClientGetAppOwnershipTicketResponse.Builder)ticketResponse.getBody()));
    }

    private void handleDepotKeyResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf keyResponse = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetDepotDecryptionKeyResponse.class, packetMsg);
        this.client.postCallback(new DepotKeyCallback(keyResponse.getTargetJobID(), (SteammessagesClientserver2.CMsgClientGetDepotDecryptionKeyResponse.Builder)keyResponse.getBody()));
    }

    private void handleGameConnectTokens(IPacketMsg packetMsg) {
        ClientMsgProtobuf gcTokens = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientGameConnectTokens.class, packetMsg);
        this.client.postCallback(new GameConnectTokensCallback((SteammessagesClientserver.CMsgClientGameConnectTokens.Builder)gcTokens.getBody()));
    }

    private void handleLegacyGameKeyResponse(IPacketMsg packetMsg) {
        ClientMsg<MsgClientGetLegacyGameKeyResponse> keyResponse = new ClientMsg<MsgClientGetLegacyGameKeyResponse>(MsgClientGetLegacyGameKeyResponse.class, packetMsg);
        this.client.postCallback(new LegacyGameKeyCallback(keyResponse.getTargetJobID(), keyResponse.getBody(), keyResponse.getPayload().toByteArray()));
    }

    private void handleLicenseList(IPacketMsg packetMsg) {
        ClientMsgProtobuf licenseList = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientLicenseList.class, packetMsg);
        this.client.postCallback(new LicenseListCallback((SteammessagesClientserver.CMsgClientLicenseList.Builder)licenseList.getBody()));
    }

    private void handleFreeLicense(IPacketMsg packetMsg) {
        ClientMsgProtobuf grantedLicenses = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRequestFreeLicenseResponse.class, packetMsg);
        this.client.postCallback(new FreeLicenseCallback(grantedLicenses.getTargetJobID(), (SteammessagesClientserver2.CMsgClientRequestFreeLicenseResponse.Builder)grantedLicenses.getBody()));
    }

    private void handlePurchaseResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf callback = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientPurchaseResponse.class, packetMsg);
        this.client.postCallback(new PurchaseResponseCallback(callback.getTargetJobID(), (SteammessagesClientserver2.CMsgClientPurchaseResponse.Builder)callback.getBody()));
    }

    private void handleRedeemGuestPassResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf callback = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientRedeemGuestPassResponse.class, packetMsg);
        this.client.postCallback(new RedeemGuestPassResponseCallback(callback.getTargetJobID(), (SteammessagesClientserver2.CMsgClientRedeemGuestPassResponse.Builder)callback.getBody()));
    }

    private void handleVACBanStatus(IPacketMsg packetMsg) {
        ClientMsg<MsgClientVACBanStatus> vacStatus = new ClientMsg<MsgClientVACBanStatus>(MsgClientVACBanStatus.class, packetMsg);
        this.client.postCallback(new VACStatusCallback(vacStatus.getBody(), vacStatus.getPayload().toByteArray()));
    }

    private void handlePICSAccessTokenResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf tokensResponse = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.class, packetMsg);
        this.client.postCallback(new PICSTokensCallback(tokensResponse.getTargetJobID(), (SteammessagesClientserverAppinfo.CMsgClientPICSAccessTokenResponse.Builder)tokensResponse.getBody()));
    }

    private void handlePICSChangesSinceResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf changesResponse = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.class, packetMsg);
        this.client.postCallback(new PICSChangesCallback(changesResponse.getTargetJobID(), (SteammessagesClientserverAppinfo.CMsgClientPICSChangesSinceResponse.Builder)changesResponse.getBody()));
    }

    private void handlePICSProductInfoResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf productResponse = new ClientMsgProtobuf(SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.class, packetMsg);
        this.client.postCallback(new PICSProductInfoCallback(productResponse.getTargetJobID(), (SteammessagesClientserverAppinfo.CMsgClientPICSProductInfoResponse.Builder)productResponse.getBody()));
    }

    private void handleGuestPassList(IPacketMsg packetMsg) {
        ClientMsg<MsgClientUpdateGuestPassesList> guestPasses = new ClientMsg<MsgClientUpdateGuestPassesList>(MsgClientUpdateGuestPassesList.class, packetMsg);
        this.client.postCallback(new GuestPassListCallback(guestPasses.getBody(), guestPasses.getPayload()));
    }

    private void handleCDNAuthTokenResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientGetCDNAuthTokenResponse.class, packetMsg);
        this.client.postCallback(new CDNAuthTokenCallback(response.getTargetJobID(), (SteammessagesClientserver2.CMsgClientGetCDNAuthTokenResponse.Builder)response.getBody()));
    }

    private void handleCheckAppBetaPasswordResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientCheckAppBetaPasswordResponse.class, packetMsg);
        this.client.postCallback(new CheckAppBetaPasswordCallback(response.getTargetJobID(), (SteammessagesClientserver2.CMsgClientCheckAppBetaPasswordResponse.Builder)response.getBody()));
    }
}

