/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamcloud;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverUfs;
import in.dragonbra.javasteam.steam.handlers.steamcloud.callback.ShareFileCallback;
import in.dragonbra.javasteam.steam.handlers.steamcloud.callback.SingleFileInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamcloud.callback.UGCDetailsCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.UGCHandle;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamCloud
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamCloud() {
        this.dispatchMap.put(EMsg.ClientUFSGetUGCDetailsResponse, this::handleUGCDetailsResponse);
        this.dispatchMap.put(EMsg.ClientUFSGetSingleFileInfoResponse, this::handleSingleFileInfoResponse);
        this.dispatchMap.put(EMsg.ClientUFSShareFileResponse, this::handleShareFileResponse);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID requestUGCDetails(UGCHandle ugcId) {
        if (ugcId == null) {
            throw new IllegalArgumentException("ugcId is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSGetUGCDetails.class, EMsg.ClientUFSGetUGCDetails);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverUfs.CMsgClientUFSGetUGCDetails.Builder)request.getBody()).setHcontent(ugcId.getValue());
        this.client.send(request);
        return jobID;
    }

    public JobID getSingleFileInfo(int appId, String filename) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfo.class, EMsg.ClientUFSGetSingleFileInfo);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfo.Builder)request.getBody()).setAppId(appId);
        ((SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfo.Builder)request.getBody()).setFileName(filename);
        this.client.send(request);
        return jobID;
    }

    public JobID shareFile(int appId, String filename) {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSShareFile.class, EMsg.ClientUFSShareFile);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverUfs.CMsgClientUFSShareFile.Builder)request.getBody()).setAppId(appId);
        ((SteammessagesClientserverUfs.CMsgClientUFSShareFile.Builder)request.getBody()).setFileName(filename);
        this.client.send(request);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleUGCDetailsResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf infoResponse = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSGetUGCDetailsResponse.class, packetMsg);
        this.client.postCallback(new UGCDetailsCallback(infoResponse.getTargetJobID(), (SteammessagesClientserverUfs.CMsgClientUFSGetUGCDetailsResponse.Builder)infoResponse.getBody()));
    }

    private void handleSingleFileInfoResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf infoResponse = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfoResponse.class, packetMsg);
        this.client.postCallback(new SingleFileInfoCallback(infoResponse.getTargetJobID(), (SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfoResponse.Builder)infoResponse.getBody()));
    }

    private void handleShareFileResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf shareResponse = new ClientMsgProtobuf(SteammessagesClientserverUfs.CMsgClientUFSShareFileResponse.class, packetMsg);
        this.client.postCallback(new ShareFileCallback(shareResponse.getTargetJobID(), (SteammessagesClientserverUfs.CMsgClientUFSShareFileResponse.Builder)shareResponse.getBody()));
    }
}

