/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamcloud.callback;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverUfs;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.Date;

public class SingleFileInfoCallback
extends CallbackMsg {
    private final EResult result;
    private final int appID;
    private final String fileName;
    private final byte[] shaHash;
    private final Date timestamp;
    private final int fileSize;
    private final boolean isExplicitDelete;

    public SingleFileInfoCallback(JobID jobID, SteammessagesClientserverUfs.CMsgClientUFSGetSingleFileInfoResponse.Builder msg) {
        this.setJobID(jobID);
        this.result = EResult.from(msg.getEresult());
        this.appID = msg.getAppId();
        this.fileName = msg.getFileName();
        this.shaHash = msg.getShaFile().toByteArray();
        this.timestamp = new Date(msg.getTimeStamp() * 1000L);
        this.fileSize = msg.getRawFileSize();
        this.isExplicitDelete = msg.getIsExplicitDelete();
    }

    public EResult getResult() {
        return this.result;
    }

    public int getAppID() {
        return this.appID;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getShaHash() {
        return this.shaHash;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public boolean isExplicitDelete() {
        return this.isExplicitDelete;
    }
}

