/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsg;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EChatAction;
import in.dragonbra.javasteam.enums.EChatEntryType;
import in.dragonbra.javasteam.enums.EChatInfoType;
import in.dragonbra.javasteam.enums.EChatMemberStateChange;
import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EPersonaState;
import in.dragonbra.javasteam.enums.EPersonaStateFlag;
import in.dragonbra.javasteam.generated.MsgClientChatAction;
import in.dragonbra.javasteam.generated.MsgClientChatActionResult;
import in.dragonbra.javasteam.generated.MsgClientChatEnter;
import in.dragonbra.javasteam.generated.MsgClientChatMemberInfo;
import in.dragonbra.javasteam.generated.MsgClientChatMsg;
import in.dragonbra.javasteam.generated.MsgClientChatRoomInfo;
import in.dragonbra.javasteam.generated.MsgClientJoinChat;
import in.dragonbra.javasteam.generated.MsgClientSetIgnoreFriend;
import in.dragonbra.javasteam.generated.MsgClientSetIgnoreFriendResponse;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverFriends;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.AliasHistoryCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ChatActionResultCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ChatEnterCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ChatInviteCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ChatMemberInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ChatMsgCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ChatRoomInfoCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ClanStateCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.FriendAddedCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.FriendMsgCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.FriendMsgEchoCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.FriendMsgHistoryCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.FriendsListCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.IgnoreFriendCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.NicknameCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.NicknameListCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.PersonaChangeCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.PersonaStatesCallback;
import in.dragonbra.javasteam.steam.handlers.steamfriends.callback.ProfileInfoCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.compat.Consumer;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SteamFriends
extends ClientMsgHandler {
    private static final Logger logger = LogManager.getLogger(SteamFriends.class);
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamFriends() {
        this.dispatchMap.put(EMsg.ClientPersonaState, this::handlePersonaState);
        this.dispatchMap.put(EMsg.ClientClanState, this::handleClanState);
        this.dispatchMap.put(EMsg.ClientFriendsList, this::handleFriendsList);
        this.dispatchMap.put(EMsg.ClientFriendMsgIncoming, this::handleFriendMsg);
        this.dispatchMap.put(EMsg.ClientFriendMsgEchoToSender, this::handleFriendEchoMsg);
        this.dispatchMap.put(EMsg.ClientChatGetFriendMessageHistoryResponse, this::handleFriendMessageHistoryResponse);
        this.dispatchMap.put(EMsg.ClientAddFriendResponse, this::handleFriendResponse);
        this.dispatchMap.put(EMsg.ClientChatEnter, this::handleChatEnter);
        this.dispatchMap.put(EMsg.ClientChatMsg, this::handleChatMsg);
        this.dispatchMap.put(EMsg.ClientChatMemberInfo, this::handleChatMemberInfo);
        this.dispatchMap.put(EMsg.ClientChatRoomInfo, this::handleChatRoomInfo);
        this.dispatchMap.put(EMsg.ClientChatActionResult, this::handleChatActionResult);
        this.dispatchMap.put(EMsg.ClientChatInvite, this::handleChatInvite);
        this.dispatchMap.put(EMsg.ClientSetIgnoreFriendResponse, this::handleIgnoreFriendResponse);
        this.dispatchMap.put(EMsg.ClientFriendProfileInfoResponse, this::handleProfileInfoResponse);
        this.dispatchMap.put(EMsg.ClientPersonaChangeResponse, this::handlePersonaChangeResponse);
        this.dispatchMap.put(EMsg.ClientPlayerNicknameList, this::handleNicknameList);
        this.dispatchMap.put(EMsg.AMClientSetPlayerNicknameResponse, this::handlePlayerNicknameResponse);
        this.dispatchMap.put(EMsg.ClientAMGetPersonaNameHistoryResponse, this::handleAliasHistoryResponse);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public void setPersonaName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        ClientMsgProtobuf stateMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientChangeStatus.class, EMsg.ClientChangeStatus);
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPlayerName(name);
        this.client.send(stateMsg);
    }

    public void setPersonaState(EPersonaState state) {
        if (state == null) {
            throw new IllegalArgumentException("state is null");
        }
        ClientMsgProtobuf stateMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientChangeStatus.class, EMsg.ClientChangeStatus);
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPersonaState(state.code());
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPersonaSetByUser(true);
        this.client.send(stateMsg);
    }

    public void resetPersonaStateFlag() {
        ClientMsgProtobuf stateMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientChangeStatus.class, EMsg.ClientChangeStatus);
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPersonaSetByUser(true);
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPersonaStateFlags(0);
        this.client.send(stateMsg);
    }

    public void setPersonaStateFlag(EPersonaStateFlag flag) {
        if (flag.code() < EPersonaStateFlag.ClientTypeWeb.code() || flag.code() > EPersonaStateFlag.ClientTypeVR.code()) {
            throw new IllegalArgumentException("Persona State Flag was not a valid ClientType");
        }
        ClientMsgProtobuf stateMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientChangeStatus.class, EMsg.ClientChangeStatus);
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPersonaSetByUser(true);
        ((SteammessagesClientserverFriends.CMsgClientChangeStatus.Builder)stateMsg.getBody()).setPersonaStateFlags(flag.code());
        this.client.send(stateMsg);
    }

    public void sendChatMessage(SteamID target, EChatEntryType type, String message) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        ClientMsgProtobuf chatMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientFriendMsg.class, EMsg.ClientFriendMsg);
        ((SteammessagesClientserverFriends.CMsgClientFriendMsg.Builder)chatMsg.getBody()).setSteamid(target.convertToUInt64());
        ((SteammessagesClientserverFriends.CMsgClientFriendMsg.Builder)chatMsg.getBody()).setChatEntryType(type.code());
        ((SteammessagesClientserverFriends.CMsgClientFriendMsg.Builder)chatMsg.getBody()).setMessage(ByteString.copyFrom((String)message, (Charset)StandardCharsets.UTF_8));
        this.client.send(chatMsg);
    }

    public void addFriend(String accountNameOrEmail) {
        if (accountNameOrEmail == null) {
            throw new IllegalArgumentException("accountNameOrEmail is null");
        }
        ClientMsgProtobuf addFriend = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientAddFriend.class, EMsg.ClientAddFriend);
        ((SteammessagesClientserverFriends.CMsgClientAddFriend.Builder)addFriend.getBody()).setAccountnameOrEmailToAdd(accountNameOrEmail);
        this.client.send(addFriend);
    }

    public void addFriend(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ClientMsgProtobuf addFriend = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientAddFriend.class, EMsg.ClientAddFriend);
        ((SteammessagesClientserverFriends.CMsgClientAddFriend.Builder)addFriend.getBody()).setSteamidToAdd(steamID.convertToUInt64());
        this.client.send(addFriend);
    }

    public void removeFriend(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ClientMsgProtobuf removeFriend = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientRemoveFriend.class, EMsg.ClientRemoveFriend);
        ((SteammessagesClientserverFriends.CMsgClientRemoveFriend.Builder)removeFriend.getBody()).setFriendid(steamID.convertToUInt64());
        this.client.send(removeFriend);
    }

    public void joinChat(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        SteamID chatID = this.fixChatID(steamID);
        ClientMsg<MsgClientJoinChat> joinChat = new ClientMsg<MsgClientJoinChat>(MsgClientJoinChat.class);
        joinChat.getBody().setSteamIdChat(chatID);
        this.client.send(joinChat);
    }

    public void leaveChat(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        SteamID chatID = this.fixChatID(steamID);
        ClientMsg<MsgClientChatMemberInfo> leaveChat = new ClientMsg<MsgClientChatMemberInfo>(MsgClientChatMemberInfo.class);
        leaveChat.getBody().setSteamIdChat(chatID);
        leaveChat.getBody().setType(EChatInfoType.StateChange);
        try {
            leaveChat.write(this.client.getSteamID().convertToUInt64());
            leaveChat.write(EChatMemberStateChange.Left.code());
            leaveChat.write(this.client.getSteamID().convertToUInt64());
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.client.send(leaveChat);
    }

    public void sendChatRoomMessage(SteamID steamIdChat, EChatEntryType type, String message) {
        if (steamIdChat == null) {
            throw new IllegalArgumentException("steamIdChat is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        SteamID chatID = this.fixChatID(steamIdChat);
        ClientMsg<MsgClientChatMsg> chatMsg = new ClientMsg<MsgClientChatMsg>(MsgClientChatMsg.class);
        chatMsg.getBody().setChatMsgType(type);
        chatMsg.getBody().setSteamIdChatRoom(chatID);
        chatMsg.getBody().setSteamIdChatter(this.client.getSteamID());
        try {
            chatMsg.writeNullTermString(message, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.client.send(chatMsg);
    }

    public void inviteUserToChat(SteamID steamIdUser, SteamID steamIdChat) {
        if (steamIdChat == null) {
            throw new IllegalArgumentException("steamIdChat is null");
        }
        if (steamIdUser == null) {
            throw new IllegalArgumentException("steamIdUser is null");
        }
        SteamID chatID = this.fixChatID(steamIdChat);
        ClientMsgProtobuf inviteMsg = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientChatInvite.class, EMsg.ClientChatInvite);
        ((SteammessagesClientserver.CMsgClientChatInvite.Builder)inviteMsg.getBody()).setSteamIdChat(chatID.convertToUInt64());
        ((SteammessagesClientserver.CMsgClientChatInvite.Builder)inviteMsg.getBody()).setSteamIdInvited(steamIdUser.convertToUInt64());
        ((SteammessagesClientserver.CMsgClientChatInvite.Builder)inviteMsg.getBody()).setSteamIdPatron(this.client.getSteamID().convertToUInt64());
        this.client.send(inviteMsg);
    }

    public void kickChatMember(SteamID steamIdChat, SteamID steamIdMember) {
        if (steamIdChat == null) {
            throw new IllegalArgumentException("steamIdChat is null");
        }
        if (steamIdMember == null) {
            throw new IllegalArgumentException("steamIdMember is null");
        }
        SteamID chatID = this.fixChatID(steamIdChat);
        ClientMsg<MsgClientChatAction> kickMember = new ClientMsg<MsgClientChatAction>(MsgClientChatAction.class);
        kickMember.getBody().setSteamIdChat(chatID);
        kickMember.getBody().setSteamIdUserToActOn(steamIdMember);
        kickMember.getBody().setChatAction(EChatAction.Kick);
        this.client.send(kickMember);
    }

    public void banChatMember(SteamID steamIdChat, SteamID steamIdMember) {
        if (steamIdChat == null) {
            throw new IllegalArgumentException("steamIdChat is null");
        }
        if (steamIdMember == null) {
            throw new IllegalArgumentException("steamIdMember is null");
        }
        SteamID chatID = this.fixChatID(steamIdChat);
        ClientMsg<MsgClientChatAction> kickMember = new ClientMsg<MsgClientChatAction>(MsgClientChatAction.class);
        kickMember.getBody().setSteamIdChat(chatID);
        kickMember.getBody().setSteamIdUserToActOn(steamIdMember);
        kickMember.getBody().setChatAction(EChatAction.Ban);
        this.client.send(kickMember);
    }

    public void unbanChatMember(SteamID steamIdChat, SteamID steamIdMember) {
        if (steamIdChat == null) {
            throw new IllegalArgumentException("steamIdChat is null");
        }
        if (steamIdMember == null) {
            throw new IllegalArgumentException("steamIdMember is null");
        }
        SteamID chatID = this.fixChatID(steamIdChat);
        ClientMsg<MsgClientChatAction> kickMember = new ClientMsg<MsgClientChatAction>(MsgClientChatAction.class);
        kickMember.getBody().setSteamIdChat(chatID);
        kickMember.getBody().setSteamIdUserToActOn(steamIdMember);
        kickMember.getBody().setChatAction(EChatAction.UnBan);
        this.client.send(kickMember);
    }

    public void requestFriendInfo(List<SteamID> steamIdList, int requestedInfo) {
        if (steamIdList == null) {
            throw new IllegalArgumentException("steamIdList is null");
        }
        if (requestedInfo == 0) {
            requestedInfo = EClientPersonaStateFlag.code(this.client.getConfiguration().getDefaultPersonaStateFlags());
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientRequestFriendData.class, EMsg.ClientRequestFriendData);
        for (SteamID steamID : steamIdList) {
            ((SteammessagesClientserverFriends.CMsgClientRequestFriendData.Builder)request.getBody()).addFriends(steamID.convertToUInt64());
        }
        ((SteammessagesClientserverFriends.CMsgClientRequestFriendData.Builder)request.getBody()).setPersonaStateRequested(requestedInfo);
        this.client.send(request);
    }

    public void requestFriendInfo(SteamID steamID, int requestedInfo) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ArrayList<SteamID> list = new ArrayList<SteamID>();
        list.add(steamID);
        this.requestFriendInfo(list, requestedInfo);
    }

    public JobID ignoreFriend(SteamID steamID) {
        return this.ignoreFriend(steamID, true);
    }

    public JobID ignoreFriend(SteamID steamID, boolean setIgnore) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ClientMsg<MsgClientSetIgnoreFriend> ignore = new ClientMsg<MsgClientSetIgnoreFriend>(MsgClientSetIgnoreFriend.class);
        JobID jobID = this.client.getNextJobID();
        ignore.setSourceJobID(jobID);
        ignore.getBody().setMySteamId(this.client.getSteamID());
        ignore.getBody().setIgnore(setIgnore ? (byte)1 : 0);
        ignore.getBody().setSteamIdFriend(steamID);
        this.client.send(ignore);
        return jobID;
    }

    public JobID requestProfileInfo(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientFriendProfileInfo.class, EMsg.ClientFriendProfileInfo);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverFriends.CMsgClientFriendProfileInfo.Builder)request.getBody()).setSteamidFriend(steamID.convertToUInt64());
        this.client.send(request);
        return jobID;
    }

    public void requestMessageHistory(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistory.class, EMsg.ClientChatGetFriendMessageHistory);
        ((SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistory.Builder)request.getBody()).setSteamid(steamID.convertToUInt64());
        this.client.send(request);
    }

    public void requestOfflineMessages() {
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistoryForOfflineMessages.class, EMsg.ClientChatGetFriendMessageHistoryForOfflineMessages);
        this.client.send(request);
    }

    public JobID setFriendNickname(SteamID friendID, String nickname) {
        if (friendID == null) {
            throw new IllegalArgumentException("friendID is null");
        }
        if (nickname == null) {
            throw new IllegalArgumentException("nickname is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientSetPlayerNickname.class, EMsg.AMClientSetPlayerNickname);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        ((SteammessagesClientserverFriends.CMsgClientSetPlayerNickname.Builder)request.getBody()).setSteamid(friendID.convertToUInt64());
        ((SteammessagesClientserverFriends.CMsgClientSetPlayerNickname.Builder)request.getBody()).setNickname(nickname);
        this.client.send(request);
        return jobID;
    }

    public JobID requestAliasHistory(SteamID steamID) {
        if (steamID == null) {
            throw new IllegalArgumentException("steamID is null");
        }
        return this.requestAliasHistory(Collections.singletonList(steamID));
    }

    public JobID requestAliasHistory(List<SteamID> steamIDs) {
        if (steamIDs == null) {
            throw new IllegalArgumentException("steamIDs is null");
        }
        ClientMsgProtobuf request = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientAMGetPersonaNameHistory.class, EMsg.ClientAMGetPersonaNameHistory);
        JobID jobID = this.client.getNextJobID();
        request.setSourceJobID(jobID);
        for (SteamID steamID : steamIDs) {
            ((SteammessagesClientserver.CMsgClientAMGetPersonaNameHistory.Builder)request.getBody()).addIds(SteammessagesClientserver.CMsgClientAMGetPersonaNameHistory.IdInstance.newBuilder().setSteamid(steamID.convertToUInt64()));
        }
        ((SteammessagesClientserver.CMsgClientAMGetPersonaNameHistory.Builder)request.getBody()).setIdCount(((SteammessagesClientserver.CMsgClientAMGetPersonaNameHistory.Builder)request.getBody()).getIdsCount());
        this.client.send(request);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private SteamID fixChatID(SteamID steamIdChat) {
        SteamID chatID = new SteamID(steamIdChat.convertToUInt64());
        if (chatID.isClanAccount()) {
            chatID = chatID.toChatID();
        }
        return chatID;
    }

    private void handleFriendMsg(IPacketMsg packetMsg) {
        ClientMsgProtobuf friendMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientFriendMsgIncoming.class, packetMsg);
        this.client.postCallback(new FriendMsgCallback((SteammessagesClientserverFriends.CMsgClientFriendMsgIncoming.Builder)friendMsg.getBody()));
    }

    private void handleFriendEchoMsg(IPacketMsg packetMsg) {
        ClientMsgProtobuf friendMsg = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientFriendMsgIncoming.class, packetMsg);
        this.client.postCallback(new FriendMsgEchoCallback((SteammessagesClientserverFriends.CMsgClientFriendMsgIncoming.Builder)friendMsg.getBody()));
    }

    private void handleFriendMessageHistoryResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf historyResponse = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistoryResponse.class, packetMsg);
        this.client.postCallback(new FriendMsgHistoryCallback((SteammessagesClientserver2.CMsgClientChatGetFriendMessageHistoryResponse.Builder)historyResponse.getBody(), this.client.getUniverse()));
    }

    private void handleFriendsList(IPacketMsg packetMsg) {
        ClientMsgProtobuf list = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientFriendsList.class, packetMsg);
        ClientMsgProtobuf reqInfo = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientRequestFriendData.class, EMsg.ClientRequestFriendData);
        ((SteammessagesClientserverFriends.CMsgClientRequestFriendData.Builder)reqInfo.getBody()).setPersonaStateRequested(EClientPersonaStateFlag.code(this.client.getConfiguration().getDefaultPersonaStateFlags()));
        for (SteammessagesClientserverFriends.CMsgClientFriendsList.Friend friendObj : ((SteammessagesClientserverFriends.CMsgClientFriendsList.Builder)list.getBody()).getFriendsList()) {
            if (((SteammessagesClientserverFriends.CMsgClientFriendsList.Builder)list.getBody()).getBincremental()) continue;
            ((SteammessagesClientserverFriends.CMsgClientRequestFriendData.Builder)reqInfo.getBody()).addFriends(friendObj.getUlfriendid());
        }
        if (((SteammessagesClientserverFriends.CMsgClientRequestFriendData.Builder)reqInfo.getBody()).getFriendsCount() > 0) {
            this.client.send(reqInfo);
        }
        this.client.postCallback(new FriendsListCallback((SteammessagesClientserverFriends.CMsgClientFriendsList.Builder)list.getBody()));
    }

    private void handlePersonaState(IPacketMsg packetMsg) {
        ClientMsgProtobuf persState = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientPersonaState.class, packetMsg);
        this.client.postCallback(new PersonaStatesCallback((SteammessagesClientserverFriends.CMsgClientPersonaState.Builder)persState.getBody()));
    }

    private void handleClanState(IPacketMsg packetMsg) {
        ClientMsgProtobuf clanState = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientClanState.class, packetMsg);
        this.client.postCallback(new ClanStateCallback((SteammessagesClientserver.CMsgClientClanState.Builder)clanState.getBody()));
    }

    private void handleFriendResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf friendResponse = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientAddFriendResponse.class, packetMsg);
        this.client.postCallback(new FriendAddedCallback((SteammessagesClientserverFriends.CMsgClientAddFriendResponse.Builder)friendResponse.getBody()));
    }

    private void handleChatEnter(IPacketMsg packetMsg) {
        ClientMsg<MsgClientChatEnter> chatEnter = new ClientMsg<MsgClientChatEnter>(MsgClientChatEnter.class, packetMsg);
        byte[] payload = chatEnter.getPayload().toByteArray();
        this.client.postCallback(new ChatEnterCallback(chatEnter.getBody(), payload));
    }

    private void handleChatMsg(IPacketMsg packetMsg) {
        ClientMsg<MsgClientChatMsg> chatMsg = new ClientMsg<MsgClientChatMsg>(MsgClientChatMsg.class, packetMsg);
        byte[] payload = chatMsg.getPayload().toByteArray();
        this.client.postCallback(new ChatMsgCallback(chatMsg.getBody(), payload));
    }

    private void handleChatMemberInfo(IPacketMsg packetMsg) {
        ClientMsg<MsgClientChatMemberInfo> membInfo = new ClientMsg<MsgClientChatMemberInfo>(MsgClientChatMemberInfo.class, packetMsg);
        byte[] payload = membInfo.getPayload().toByteArray();
        this.client.postCallback(new ChatMemberInfoCallback(membInfo.getBody(), payload));
    }

    private void handleChatRoomInfo(IPacketMsg packetMsg) {
        ClientMsg<MsgClientChatRoomInfo> roomInfo = new ClientMsg<MsgClientChatRoomInfo>(MsgClientChatRoomInfo.class, packetMsg);
        byte[] payload = roomInfo.getPayload().toByteArray();
        this.client.postCallback(new ChatRoomInfoCallback(roomInfo.getBody(), payload));
    }

    private void handleChatActionResult(IPacketMsg packetMsg) {
        ClientMsg<MsgClientChatActionResult> actionResult = new ClientMsg<MsgClientChatActionResult>(MsgClientChatActionResult.class, packetMsg);
        this.client.postCallback(new ChatActionResultCallback(actionResult.getBody()));
    }

    private void handleChatInvite(IPacketMsg packetMsg) {
        ClientMsgProtobuf chatInvite = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientChatInvite.class, packetMsg);
        this.client.postCallback(new ChatInviteCallback((SteammessagesClientserver.CMsgClientChatInvite.Builder)chatInvite.getBody()));
    }

    private void handleIgnoreFriendResponse(IPacketMsg packetMsg) {
        ClientMsg<MsgClientSetIgnoreFriendResponse> response = new ClientMsg<MsgClientSetIgnoreFriendResponse>(MsgClientSetIgnoreFriendResponse.class, packetMsg);
        this.client.postCallback(new IgnoreFriendCallback(response.getTargetJobID(), response.getBody()));
    }

    private void handleProfileInfoResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientFriendProfileInfoResponse.class, packetMsg);
        this.client.postCallback(new ProfileInfoCallback(new JobID(packetMsg.getTargetJobID()), (SteammessagesClientserverFriends.CMsgClientFriendProfileInfoResponse.Builder)response.getBody()));
    }

    private void handlePersonaChangeResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf response = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgPersonaChangeResponse.class, packetMsg);
        this.client.postCallback(new PersonaChangeCallback(new JobID(packetMsg.getTargetJobID()), (SteammessagesClientserverFriends.CMsgPersonaChangeResponse.Builder)response.getBody()));
    }

    private void handleNicknameList(IPacketMsg packetMsg) {
        ClientMsgProtobuf resp = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientPlayerNicknameList.class, packetMsg);
        this.client.postCallback(new NicknameListCallback((SteammessagesClientserverFriends.CMsgClientPlayerNicknameList.Builder)resp.getBody()));
    }

    private void handlePlayerNicknameResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf resp = new ClientMsgProtobuf(SteammessagesClientserverFriends.CMsgClientSetPlayerNicknameResponse.class, packetMsg);
        this.client.postCallback(new NicknameCallback(resp.getTargetJobID(), (SteammessagesClientserverFriends.CMsgClientSetPlayerNicknameResponse.Builder)resp.getBody()));
    }

    private void handleAliasHistoryResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf resp = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientAMGetPersonaNameHistoryResponse.class, packetMsg);
        this.client.postCallback(new AliasHistoryCallback(resp.getTargetJobID(), (SteammessagesClientserver.CMsgClientAMGetPersonaNameHistoryResponse.Builder)resp.getBody()));
    }
}

