/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends.callback;

import in.dragonbra.javasteam.enums.EChatRoomType;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.GameID;
import in.dragonbra.javasteam.types.SteamID;

public class ChatInviteCallback
extends CallbackMsg {
    private final SteamID invitedID;
    private final SteamID chatRoomID;
    private final SteamID patronID;
    private final EChatRoomType chatRoomType;
    private final SteamID friendChatID;
    private final String chatRoomName;
    private final GameID gameID;

    public ChatInviteCallback(SteammessagesClientserver.CMsgClientChatInvite.Builder invite) {
        this.invitedID = new SteamID(invite.getSteamIdInvited());
        this.chatRoomID = new SteamID(invite.getSteamIdChat());
        this.patronID = new SteamID(invite.getSteamIdPatron());
        this.chatRoomType = EChatRoomType.from(invite.getChatroomType());
        this.friendChatID = new SteamID(invite.getSteamIdFriendChat());
        this.chatRoomName = invite.getChatName();
        this.gameID = new GameID(invite.getGameId());
    }

    public SteamID getInvitedID() {
        return this.invitedID;
    }

    public SteamID getChatRoomID() {
        return this.chatRoomID;
    }

    public SteamID getPatronID() {
        return this.patronID;
    }

    public EChatRoomType getChatRoomType() {
        return this.chatRoomType;
    }

    public SteamID getFriendChatID() {
        return this.friendChatID;
    }

    public String getChatRoomName() {
        return this.chatRoomName;
    }

    public GameID getGameID() {
        return this.gameID;
    }
}

