/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamgameserver;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EAccountType;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.enums.EServerFlags;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverGameservers;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.LogOnDetails;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.StatusDetails;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.callback.StatusReplyCallback;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.callback.TicketAuthCallback;
import in.dragonbra.javasteam.steam.handlers.steamuser.callback.LoggedOnCallback;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.HardwareUtils;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.net.Inet6Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamGameServer
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamGameServer() {
        this.dispatchMap.put(EMsg.GSStatusReply, this::handleStatusReply);
        this.dispatchMap.put(EMsg.ClientTicketAuthComplete, this::handleAuthComplete);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public void logOn(LogOnDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        if (Strings.isNullOrEmpty(details.getToken())) {
            throw new IllegalArgumentException("LogOn requires a game server token to be set in 'details'.");
        }
        if (!this.client.isConnected()) {
            this.client.postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogonGameServer);
        SteamID gsId = new SteamID(0L, 0L, this.client.getUniverse(), EAccountType.GameServer);
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(gsId.convertToUInt64());
        int localIp = NetHelpers.getIPAddress(this.client.getLocalIP());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(localIp ^ 0xBAADF00D);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65580);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(Utils.getOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGameServerAppId(details.getAppID());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGameServerToken(details.getToken());
        this.client.send(logon);
    }

    public void logOnAnonymous() {
        this.logOnAnonymous(0);
    }

    public void logOnAnonymous(int appId) {
        if (!this.client.isConnected()) {
            this.client.postCallback(new LoggedOnCallback(EResult.NoConnection));
            return;
        }
        ClientMsgProtobuf logon = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogon.class, EMsg.ClientLogonGameServer);
        SteamID gsId = new SteamID(0L, 0L, this.client.getUniverse(), EAccountType.AnonGameServer);
        logon.getProtoHeader().setClientSessionid(0);
        logon.getProtoHeader().setSteamid(gsId.convertToUInt64());
        int localIp = NetHelpers.getIPAddress(this.client.getLocalIP());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setDeprecatedObfustucatedPrivateIp(localIp ^ 0xBAADF00D);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setProtocolVersion(65580);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setClientOsType(Utils.getOSType().code());
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setGameServerAppId(appId);
        ((SteammessagesClientserverLogin.CMsgClientLogon.Builder)logon.getBody()).setMachineId(ByteString.copyFrom((byte[])HardwareUtils.getMachineID()));
        this.client.send(logon);
    }

    public void logOff() {
        this.setExpectDisconnection(true);
        ClientMsgProtobuf logOff = new ClientMsgProtobuf(SteammessagesClientserverLogin.CMsgClientLogOff.class, EMsg.ClientLogOff);
        this.client.send(logOff);
        this.client.disconnect();
    }

    public void sendStatus(StatusDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        if (details.getAddress() != null && details.getAddress() instanceof Inet6Address) {
            throw new IllegalArgumentException("Only IPv4 addresses are supported.");
        }
        ClientMsgProtobuf status = new ClientMsgProtobuf(SteammessagesClientserverGameservers.CMsgGSServerType.class, EMsg.GSServerType);
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setAppIdServed(details.getAppID());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setFlags(EServerFlags.code(details.getServerFlags()));
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGameDir(details.getGameDirectory());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGamePort(details.getPort());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGameQueryPort(details.getQueryPort());
        ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setGameVersion(details.getVersion());
        if (details.getAddress() != null) {
            ((SteammessagesClientserverGameservers.CMsgGSServerType.Builder)status.getBody()).setDeprecatedGameIpAddress(NetHelpers.getIPAddress(details.getAddress()));
        }
        this.client.send(status);
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleStatusReply(IPacketMsg packetMsg) {
        ClientMsgProtobuf statusReply = new ClientMsgProtobuf(SteammessagesClientserverGameservers.CMsgGSStatusReply.class, packetMsg);
        this.client.postCallback(new StatusReplyCallback((SteammessagesClientserverGameservers.CMsgGSStatusReply.Builder)statusReply.getBody()));
    }

    private void handleAuthComplete(IPacketMsg packetMsg) {
        ClientMsgProtobuf statusReply = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientTicketAuthComplete.class, packetMsg);
        this.client.postCallback(new TicketAuthCallback((SteammessagesClientserver.CMsgClientTicketAuthComplete.Builder)statusReply.getBody()));
    }
}

