/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steammasterserver;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverGameservers;
import in.dragonbra.javasteam.steam.handlers.steammasterserver.QueryDetails;
import in.dragonbra.javasteam.steam.handlers.steammasterserver.callback.QueryCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.NetHelpers;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamMasterServer
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamMasterServer() {
        this.dispatchMap.put(EMsg.GMSClientServerQueryResponse, this::handleServerQueryResponse);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID serverQuery(QueryDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("details is null");
        }
        ClientMsgProtobuf query = new ClientMsgProtobuf(SteammessagesClientserverGameservers.CMsgClientGMSServerQuery.class, EMsg.ClientGMSServerQuery);
        JobID jobID = this.client.getNextJobID();
        query.setSourceJobID(jobID);
        ((SteammessagesClientserverGameservers.CMsgClientGMSServerQuery.Builder)query.getBody()).setAppId(details.getAppID());
        if (details.getGeoLocatedIP() != null) {
            ((SteammessagesClientserverGameservers.CMsgClientGMSServerQuery.Builder)query.getBody()).setGeoLocationIp(NetHelpers.getIPAddress(details.getGeoLocatedIP()));
        }
        ((SteammessagesClientserverGameservers.CMsgClientGMSServerQuery.Builder)query.getBody()).setFilterText(details.getFilter());
        ((SteammessagesClientserverGameservers.CMsgClientGMSServerQuery.Builder)query.getBody()).setRegionCode(details.getRegion().code());
        ((SteammessagesClientserverGameservers.CMsgClientGMSServerQuery.Builder)query.getBody()).setMaxServers(details.getMaxServers());
        this.client.send(query);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleServerQueryResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf queryResponse = new ClientMsgProtobuf(SteammessagesClientserverGameservers.CMsgGMSClientServerQueryResponse.class, packetMsg);
        this.client.postCallback(new QueryCallback(queryResponse.getTargetJobID(), (SteammessagesClientserverGameservers.CMsgGMSClientServerQueryResponse.Builder)queryResponse.getBody()));
    }
}

