/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamunifiedmessages;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.PacketClientMsgProtobuf;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgHdrProtoBuf;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodNotification;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.compat.Consumer;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamUnifiedMessages
extends ClientMsgHandler {
    private static final Logger logger = LogManager.getLogger(SteamUnifiedMessages.class);
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamUnifiedMessages() {
        this.dispatchMap.put(EMsg.ServiceMethodResponse, this::handleServiceMethodResponse);
        this.dispatchMap.put(EMsg.ServiceMethod, this::handleServiceMethod);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    public <TRequest extends GeneratedMessageV3.Builder<TRequest>> JobID sendMessage(String rpcName, GeneratedMessageV3 message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        JobID jobID = this.client.getNextJobID();
        EMsg eMsg = this.client.getSteamID() == null ? EMsg.ServiceMethodCallFromClientNonAuthed : EMsg.ServiceMethodCallFromClient;
        ClientMsgProtobuf msg = new ClientMsgProtobuf(message.getClass(), eMsg);
        msg.setSourceJobID(jobID);
        ((MsgHdrProtoBuf)msg.getHeader()).getProto().setTargetJobName(rpcName);
        msg.getBody().mergeFrom((Message)message);
        this.client.send(msg);
        return jobID;
    }

    public <TRequest extends GeneratedMessageV3.Builder<TRequest>> void sendNotification(String rpcName, GeneratedMessageV3 message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        EMsg eMsg = this.client.getSteamID() == null ? EMsg.ServiceMethodCallFromClientNonAuthed : EMsg.ServiceMethodCallFromClient;
        ClientMsgProtobuf msg = new ClientMsgProtobuf(message.getClass(), eMsg);
        ((MsgHdrProtoBuf)msg.getHeader()).getProto().setTargetJobName(rpcName);
        msg.getBody().mergeFrom((Message)message);
        this.client.send(msg);
    }

    private void handleServiceMethodResponse(IPacketMsg packetMsg) {
        if (!(packetMsg instanceof PacketClientMsgProtobuf)) {
            throw new IllegalArgumentException("Packet message is expected to be protobuf.");
        }
        PacketClientMsgProtobuf packetMsgProto = (PacketClientMsgProtobuf)packetMsg;
        this.client.postCallback(new ServiceMethodResponse(packetMsgProto));
    }

    private void handleServiceMethod(IPacketMsg packetMsg) {
        if (!(packetMsg instanceof PacketClientMsgProtobuf)) {
            throw new IllegalArgumentException("Packet message is expected to be protobuf.");
        }
        PacketClientMsgProtobuf packetMsgProto = (PacketClientMsgProtobuf)packetMsg;
        String jobName = packetMsgProto.getHeader().getProto().getTargetJobName();
        if (!Strings.isNullOrEmpty(jobName)) {
            String[] splitByDot = jobName.split("\\.");
            String[] splitByHash = splitByDot[1].split("#");
            String serviceName = splitByDot[0];
            String methodName = splitByHash[0];
            String serviceInterfaceName = "in.dragonbra.javasteam.rpc.I" + serviceName;
            try {
                logger.debug("Handling Service Method: " + serviceInterfaceName);
                Class<?> serviceInterfaceType = Class.forName(serviceInterfaceName);
                Method method = null;
                for (Method m : serviceInterfaceType.getDeclaredMethods()) {
                    if (!m.getName().equals(methodName)) continue;
                    method = m;
                }
                if (method != null) {
                    Class<?> argumentType = method.getParameterTypes()[0];
                    this.client.postCallback(new ServiceMethodNotification(argumentType, packetMsg));
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Service Method: " + serviceName + ", was not found");
            }
        }
    }
}

