/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamunifiedmessages;

import com.google.protobuf.GeneratedMessageV3;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages;
import in.dragonbra.javasteam.types.JobID;

public abstract class UnifiedService {
    private final SteamUnifiedMessages steamUnifiedMessages;

    public UnifiedService(SteamUnifiedMessages steamUnifiedMessages) {
        this.steamUnifiedMessages = steamUnifiedMessages;
    }

    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    private static String getRpcEndpoint(String parentClassName, String methodName) {
        return String.format("%s.%s#%s", parentClassName, methodName, 1);
    }

    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[3].getMethodName();
    }

    public JobID sendMessage(GeneratedMessageV3 message) {
        String serviceName = this.getClassName();
        String rpcName = UnifiedService.getMethodName();
        String rpcEndpoint = UnifiedService.getRpcEndpoint(serviceName, rpcName);
        return this.sendMessageOrNotification(rpcEndpoint, message, false);
    }

    public void sendNotification(GeneratedMessageV3 message) {
        String serviceName = this.getClassName();
        String rpcName = UnifiedService.getMethodName();
        String rpcEndpoint = UnifiedService.getRpcEndpoint(serviceName, rpcName);
        this.sendMessageOrNotification(rpcEndpoint, message, true);
    }

    private JobID sendMessageOrNotification(String rpcName, GeneratedMessageV3 message, Boolean isNotification) {
        if (isNotification.booleanValue()) {
            this.steamUnifiedMessages.sendNotification(rpcName, message);
            return null;
        }
        return this.steamUnifiedMessages.sendMessage(rpcName, message);
    }
}

