/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessageV3;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.PacketClientMsgProtobuf;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;

public class ServiceMethodResponse
extends CallbackMsg {
    private final EResult result;
    private final String methodName;
    private final PacketClientMsgProtobuf packetMsg;

    public ServiceMethodResponse(PacketClientMsgProtobuf packetMsg) {
        SteammessagesBase.CMsgProtoBufHeader protoHeader = packetMsg.getHeader().getProto().build();
        JobID jobID = new JobID(protoHeader.getJobidTarget());
        this.setJobID(jobID);
        this.result = EResult.from(protoHeader.getEresult());
        this.methodName = protoHeader.getTargetJobName();
        this.packetMsg = packetMsg;
    }

    public EResult getResult() {
        return this.result;
    }

    public String getServiceName() {
        return this.methodName.split("\\.")[0];
    }

    public String getRpcName() {
        return this.methodName.substring(this.getServiceName().length() + 1).split("#")[0];
    }

    public String getMethodName() {
        return this.methodName;
    }

    public <T extends GeneratedMessageV3.Builder<T>> T getDeserializedResponse(Class<? extends AbstractMessage> clazz) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(clazz, this.packetMsg);
        return (T)msg.getBody();
    }
}

