/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuser.callback;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import in.dragonbra.javasteam.enums.EAccountFlags;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.generated.MsgClientLogOnResponse;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLogin;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.NetHelpers;
import java.net.InetAddress;
import java.util.Date;
import java.util.EnumSet;

public class LoggedOnCallback
extends CallbackMsg {
    private final EResult result;
    private EResult extendedResult;
    private int outOfGameSecsPerHeartbeat;
    private int inGameSecsPerHeartbeat;
    private InetAddress publicIP;
    private Date serverTime;
    private EnumSet<EAccountFlags> accountFlags;
    private SteamID clientSteamID;
    private String emailDomain;
    private int cellID;
    private int cellIDPingThreshold;
    private byte[] steam2Ticket;
    private String webAPIUserNonce;
    private String ipCountryCode;
    private String vanityURL;
    private int numLoginFailuresToMigrate;
    private int numDisconnectsToMigrate;
    private SteammessagesParentalSteamclient.ParentalSettings parentalSettings;

    public LoggedOnCallback(SteammessagesClientserverLogin.CMsgClientLogonResponse.Builder resp) {
        this.result = EResult.from(resp.getEresult());
        this.extendedResult = EResult.from(resp.getEresultExtended());
        this.outOfGameSecsPerHeartbeat = resp.getLegacyOutOfGameHeartbeatSeconds();
        this.inGameSecsPerHeartbeat = resp.getHeartbeatSeconds();
        this.publicIP = NetHelpers.getIPAddress(resp.getPublicIp().getV4());
        this.serverTime = new Date((long)resp.getRtime32ServerTime() * 1000L);
        this.accountFlags = EAccountFlags.from(resp.getAccountFlags());
        this.clientSteamID = new SteamID(resp.getClientSuppliedSteamid());
        this.emailDomain = resp.getEmailDomain();
        this.cellID = resp.getCellId();
        this.cellIDPingThreshold = resp.getCellIdPingThreshold();
        this.steam2Ticket = resp.getSteam2Ticket().toByteArray();
        this.ipCountryCode = resp.getIpCountryCode();
        this.webAPIUserNonce = resp.getWebapiAuthenticateUserNonce();
        this.vanityURL = resp.getVanityUrl();
        this.numLoginFailuresToMigrate = resp.getCountLoginfailuresToMigrate();
        this.numDisconnectsToMigrate = resp.getCountDisconnectsToMigrate();
        ByteString data = resp.getParentalSettings();
        if (data != null) {
            try {
                this.parentalSettings = SteammessagesParentalSteamclient.ParentalSettings.parseFrom(data);
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
    }

    public LoggedOnCallback(MsgClientLogOnResponse resp) {
        this.result = resp.getResult();
        this.outOfGameSecsPerHeartbeat = resp.getOutOfGameHeartbeatRateSec();
        this.inGameSecsPerHeartbeat = resp.getInGameHeartbeatRateSec();
        this.publicIP = NetHelpers.getIPAddress(resp.getIpPublic());
        this.serverTime = new Date((long)resp.getServerRealTime() * 1000L);
        this.clientSteamID = resp.getClientSuppliedSteamId();
    }

    public LoggedOnCallback(EResult result) {
        this.result = result;
    }

    public EResult getResult() {
        return this.result;
    }

    public EResult getExtendedResult() {
        return this.extendedResult;
    }

    public int getOutOfGameSecsPerHeartbeat() {
        return this.outOfGameSecsPerHeartbeat;
    }

    public int getInGameSecsPerHeartbeat() {
        return this.inGameSecsPerHeartbeat;
    }

    public InetAddress getPublicIP() {
        return this.publicIP;
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public EnumSet<EAccountFlags> getAccountFlags() {
        return this.accountFlags;
    }

    public SteamID getClientSteamID() {
        return this.clientSteamID;
    }

    public String getEmailDomain() {
        return this.emailDomain;
    }

    public int getCellID() {
        return this.cellID;
    }

    public int getCellIDPingThreshold() {
        return this.cellIDPingThreshold;
    }

    public byte[] getSteam2Ticket() {
        return this.steam2Ticket;
    }

    public String getWebAPIUserNonce() {
        return this.webAPIUserNonce;
    }

    public String getIpCountryCode() {
        return this.ipCountryCode;
    }

    public String getVanityURL() {
        return this.vanityURL;
    }

    public int getNumLoginFailuresToMigrate() {
        return this.numLoginFailuresToMigrate;
    }

    public int getNumDisconnectsToMigrate() {
        return this.numDisconnectsToMigrate;
    }

    public SteammessagesParentalSteamclient.ParentalSettings getParentalSettings() {
        return this.parentalSettings;
    }
}

