/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuser.callback;

import in.dragonbra.javasteam.enums.EMarketingMessageFlags;
import in.dragonbra.javasteam.generated.MsgClientMarketingMessageUpdate2;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.GlobalID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;

public class MarketingMessageCallback
extends CallbackMsg {
    private static final Logger logger = LogManager.getLogger(MarketingMessageCallback.class);
    private final Date updateTime;
    private final Collection<Message> messages;

    public MarketingMessageCallback(MsgClientMarketingMessageUpdate2 body, byte[] payload) {
        this.updateTime = new Date((long)body.getMarketingMessageUpdateTime() * 1000L);
        ArrayList<Message> msgList = new ArrayList<Message>();
        try (BinaryReader br = new BinaryReader(new ByteArrayInputStream(payload));){
            for (int i = 0; i < body.getCount(); ++i) {
                int dataLen = br.readInt() - 4;
                byte[] messageData = br.readBytes(dataLen);
                msgList.add(new Message(messageData));
            }
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.messages = Collections.unmodifiableList(msgList);
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Collection<Message> getMessages() {
        return this.messages;
    }

    public static class Message {
        private GlobalID id;
        private String url;
        private EnumSet<EMarketingMessageFlags> flags;

        Message(byte[] data) {
            try (BinaryReader br = new BinaryReader(new ByteArrayInputStream(data));){
                this.id = new GlobalID(br.readLong());
                this.url = br.readNullTermString(StandardCharsets.UTF_8);
                this.flags = EMarketingMessageFlags.from(br.readInt());
            }
            catch (IOException e) {
                logger.debug(e);
            }
        }

        public GlobalID getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public EnumSet<EMarketingMessageFlags> getFlags() {
            return this.flags;
        }
    }
}

