/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuserstats;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.ELeaderboardDataRequest;
import in.dragonbra.javasteam.enums.ELeaderboardDisplayType;
import in.dragonbra.javasteam.enums.ELeaderboardSortMethod;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLbs;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.callback.FindOrCreateLeaderboardCallback;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.callback.LeaderboardEntriesCallback;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.callback.NumberOfPlayersCallback;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamUserStats
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamUserStats() {
        this.dispatchMap.put(EMsg.ClientGetNumberOfCurrentPlayersDPResponse, this::handleNumberOfPlayersResponse);
        this.dispatchMap.put(EMsg.ClientLBSFindOrCreateLBResponse, this::handleFindOrCreateLBResponse);
        this.dispatchMap.put(EMsg.ClientLBSGetLBEntriesResponse, this::handleGetLBEntriesResponse);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public JobID getNumberOfCurrentPlayers(int appId) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgDPGetNumberOfCurrentPlayers.class, EMsg.ClientGetNumberOfCurrentPlayersDP);
        JobID jobID = this.client.getNextJobID();
        msg.setSourceJobID(jobID);
        ((SteammessagesClientserver2.CMsgDPGetNumberOfCurrentPlayers.Builder)msg.getBody()).setAppid(appId);
        this.client.send(msg);
        return jobID;
    }

    public JobID findLeaderBoard(int appId, String name) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.class, EMsg.ClientLBSFindOrCreateLB);
        JobID jobID = this.client.getNextJobID();
        msg.setSourceJobID(jobID);
        msg.getProtoHeader().setRoutingAppid(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardName(name);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setCreateIfNotFound(false);
        this.client.send(msg);
        return jobID;
    }

    public JobID createLeaderboard(int appId, String name, ELeaderboardSortMethod sortMethod, ELeaderboardDisplayType displayType) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.class, EMsg.ClientLBSFindOrCreateLB);
        JobID jobID = this.client.getNextJobID();
        msg.setSourceJobID(jobID);
        msg.getProtoHeader().setRoutingAppid(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardName(name);
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardDisplayType(displayType.code());
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setLeaderboardSortMethod(sortMethod.code());
        ((SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLB.Builder)msg.getBody()).setCreateIfNotFound(true);
        this.client.send(msg);
        return jobID;
    }

    public JobID getLeaderboardEntries(int appId, int id, int rangeStart, int rangeEnd, ELeaderboardDataRequest dataRequest) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.class, EMsg.ClientLBSGetLBEntries);
        JobID jobID = this.client.getNextJobID();
        msg.setSourceJobID(jobID);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setLeaderboardId(id);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setLeaderboardDataRequest(dataRequest.code());
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setRangeStart(rangeStart);
        ((SteammessagesClientserverLbs.CMsgClientLBSGetLBEntries.Builder)msg.getBody()).setRangeEnd(rangeEnd);
        this.client.send(msg);
        return jobID;
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleNumberOfPlayersResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgDPGetNumberOfCurrentPlayersResponse.class, packetMsg);
        this.client.postCallback(new NumberOfPlayersCallback(msg.getTargetJobID(), (SteammessagesClientserver2.CMsgDPGetNumberOfCurrentPlayersResponse.Builder)msg.getBody()));
    }

    private void handleFindOrCreateLBResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLBResponse.class, packetMsg);
        this.client.postCallback(new FindOrCreateLeaderboardCallback(msg.getTargetJobID(), (SteammessagesClientserverLbs.CMsgClientLBSFindOrCreateLBResponse.Builder)msg.getBody()));
    }

    private void handleGetLBEntriesResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserverLbs.CMsgClientLBSGetLBEntriesResponse.class, packetMsg);
        this.client.postCallback(new LeaderboardEntriesCallback(msg.getTargetJobID(), (SteammessagesClientserverLbs.CMsgClientLBSGetLBEntriesResponse.Builder)msg.getBody()));
    }
}

